#include <SoftwareSerial.h> // dołącz obsługę UART dla pozostałych wyprowadzeń
#include "DHT.h"            // i obsługę czujnika DHT

#define serialSpeed 115200 // prędkość transmisji UART
#define DEBUG false        // true drukuje otrzymane dane z UART

SoftwareSerial esp8266(2,3); // RX, TX

char wifi_ssid[]   = "nazwa sieci WiFi";
char wifi_passwd[] = "hasło";

#define DHTPIN 7      // numer GPIO dla linii sygnałowej DAT w DHT11
#define DHTTYPE DHT11 // typ czujnika DHT
/*
#define DHTTYPE DHT21 // DHT 21 (AM2301)
#define DHTTYPE DHT22 // DHT 22 (AM2302), AM2321
*/

DHT dht(DHTPIN, DHTTYPE); // obiekt obsługujący czujnik DHT

String webpage = ""; // dokument hipertekstowy wysyłany do przeglądarki
String resdata = ""; // odpowiedź na żądanie XMLHttpRequest
String httpGet = ""; // zapytanie HTTP GET - żądany adres URL

String *cipData;     // bufor na pakiet danych
int cipLength = 0;

// zmienne pomocnicze
char oneChar = "";
int cntChars = 0;
char buff[10];

void setup() {
  // prędkość komunikacji na interfejsach UART
  Serial.begin(serialSpeed);
  esp8266.begin(serialSpeed); 

  prepareWebPage(); // przygotuj kod HTML dla strony WWW

  Serial.print(F("Inicjalizacja czujnika DHT ... "));
  dht.begin(); // aktywuj odczyt z czujnika DHT
  Serial.println(F("gotowe!"));

  Serial.println(F("Inicjalizacja modułu WiFi"));
  InitWifiModule(); // aktywuj moduł WiFi i czekaj na połączenia klientów
  Serial.println(F("Czekam na połączenia klientów ..."));
}

void loop() {
  // obsługa połączeń klientów
  if(esp8266.available()) // odebrano dane
  {
    if(esp8266.find("+IPD,")) // dekoduj pakiet
    {
      delay(100);

      Serial.print(F("Obsługa klienta na kanale "));
      int connectionId = esp8266.read()-48; // numer kanału
      Serial.println(connectionId);

      // dekodowanie adresu URL
      if(esp8266.find("GET /")) { // czy zapytanie HTTP GET?

        // zeruj zmienne pomocnicze
        cntChars = 0;
        oneChar = "";
        httpGet = "";

        // zdekodowanie żądanego adresu URL np.: http://twój_IP/data, 
        // przykładowy format zapytania HTTP: GET /data HTTP/1.1
        while(cntChars < 50) { // sprawdź maksymalnie pierwsze 50 znaków
          oneChar = esp8266.read(); // odczytaj kolejny znak
          if (int(oneChar) == 32) { // jeśli pojawi się znak spacji przerwij pętlę
            break;
          }
          httpGet.concat(oneChar); // dodaj kolejny znak do zmiennej tekstowej
          cntChars++; // zwiększ licznik pętli
        }

        Serial.print(F("Otrzymano żądanie dla adresu URL: /"));
        Serial.println(httpGet);
      }

      if (httpGet == "data") { // jeśli żądany URL to /data wyślij dane z czujników
        Serial.println(F("Otrzymano XMLHttpRequest ..."));

        float temp = dht.readTemperature();
        float hmd = dht.readHumidity();

        resdata = "#TEMP#,#HMD#";

        // wstaw  wartość temperatury
        sprintf(buff, "%d.%02d", (int)temp, (int)(temp*100)%100);
        resdata.replace("#TEMP#", buff);

        // wstaw wartość wilgotności
        sprintf(buff, "%d.%02d", (int)hmd, (int)(hmd*100)%100);
        resdata.replace("#HMD#", buff);

        cipLength = resdata.length();
        cipData = &resdata;
      } else if (httpGet != "data" && httpGet.length() > 0) {
        resdata = "?,?";
        cipLength = resdata.length();
        cipData = &resdata;
      } else { // strona główna
        cipLength = webpage.length();
        cipData = &webpage;
      }

      Serial.print(F("Wysyłam dane do klienta ... "));
      String cipSend = "AT+CIPSEND=";
      cipSend += connectionId;
      cipSend += ",";
      cipSend += cipLength;
      cipSend +="\r\n";      

      sendData(&cipSend, 1000, DEBUG); // przygotuj pakiet do wysyłki
      sendData(cipData, 1000, DEBUG); // wyślij pakiet danych

      Serial.print(F("wysłano ... "));

      String closeCommand = "AT+CIPCLOSE="; 
      closeCommand+=connectionId;
      closeCommand+="\r\n";    
      sendData(&closeCommand, 3000, DEBUG); // zamknij połączenie

      Serial.println(F("połączenie zamknięte."));
    }
  }
}

String prepareWebPage() {
  // kod HTML strony startowej

  webpage = String(F("<!doctype html>"));
  webpage.concat(F("<html>"));
  webpage.concat(F("<head>"));
  webpage.concat(F("<meta charset=\"utf-8\">"));
  webpage.concat(F("<title>Mój Smart Home</title>"));
  webpage.concat(F("<style>"));
  webpage.concat(F("body { padding: 2rem; }"));
  webpage.concat(F("h1 { font-size: 2rem; }"));
  webpage.concat(F("h2 { font-size: 1rem; }"));
  webpage.concat(F(".item { font-size: 2.5rem; }"));
  webpage.concat(F(".item .unit { font-size: 1.0rem; margin-left: 5px; }"));
  webpage.concat(F("</style>"));
  webpage.concat(F("</head>"));
  webpage.concat(F("<body>"));
  webpage.concat(F("<h1>Mój Smart Home</h1>"));
  webpage.concat(F("<h2>Pomiar temperatury i wilgotności</h2>"));
  webpage.concat(F("<p class=\"item\">Temperatura <span id=\"temp\">0.0</span><sup class=\"unit\">°C</sup></p>"));
  webpage.concat(F("<p class=\"item\">Wilgotność <span id=\"hmd\">0.0</span><sup class=\"unit\">%</sup></p>"));
  webpage.concat(F("<hr>"));
  webpage.concat(F("<p><small><em>Dane odświeżane co 30 sekund.</em></small></p>"));
  webpage.concat(F("</body>"));
  webpage.concat(F("<script>"));
  webpage.concat(F("function getData(){")); // funkcja pobierająca dane z czujników
  webpage.concat(F("var xhttp = new XMLHttpRequest();"));
  webpage.concat(F("xhttp.onreadystatechange = function(){"));
  webpage.concat(F("if (this.readyState == 4 && this.status == 200){"));
  webpage.concat(F("data = this.responseText;"));
  webpage.concat(F("data = data.split(',');"));
  webpage.concat(F("document.getElementById('temp').innerHTML = data[0];"));
  webpage.concat(F("document.getElementById('hmd').innerHTML = data[1];"));
  webpage.concat(F("}"));
  webpage.concat(F("};"));
  webpage.concat(F("xhttp.open('GET', '/data', true);"));
  webpage.concat(F("xhttp.send();"));
  webpage.concat(F("};"));
  // uruchamiaj funkcję getData() do 30 sekund
  webpage.concat(F("setInterval(getData, 30000);"));
  // pierwsze dane pobierz po 5 sekundach od wgrania strony do przeglądarki
  webpage.concat(F("setTimeout(function() { getData(); }, 5000);")); 
  webpage.concat(F("</script>"));
  webpage.concat(F("</html>"));  
}

void InitWifiModule()
{
  String command = "";
  // sendData("AT+RESTORE\r\n", 2000, DEBUG); // przywrócenie ustawień domyślnych

  command = "AT+RST\r\n";
  sendData(&command, 2000, DEBUG); // reset modułu WiFi
  
  Serial.println(F("=> Ustawiam moduł w trybie klienta."));
  command = "AT+CWMODE=1\r\n";
  sendData(&command, 1500, DEBUG); // tryb klienta

  // przygotuj polecenie do połaczenia się z siecią WiFi
  Serial.println(F("=> Łączę moduł z siecią WiFi."));
  String cwjap = "AT+CWJAP=\"";
  cwjap.concat(wifi_ssid);
  cwjap.concat("\",\"");
  cwjap.concat(wifi_passwd);
  cwjap.concat("\"\r\n");
  sendData(&cwjap, 3000, DEBUG); // połącz z siecią WiFi
  delay(5000); // poczekaj, aż moduł WiFi połączy się z punktem dostępowym
  
  Serial.print(F("=> Pobieram adres IP ... "));
  String response = "";
  for (int i = 0; i <= 1; i++) { // 2 próby uzyskania adresu IP
    command = "AT+CIFSR\r\n";
    response = sendData(&command, 2000, DEBUG); // pobierz adres IP
    if (response.indexOf("STAIP,") > 0) {
      break;
    }
  }

  // wyodrębnij adres IP z danych odebranych przez UART
  int index = response.indexOf("STAIP,");
  if (index != -1) {
    String ip = response.substring(index + 7, response.indexOf('"', index + 7));
    Serial.println(ip);
    Serial.print(F("=> Po uruchomieniu serwera TCP wejdź na stronę http://"));
    Serial.println(ip);
  } else {
    // sprawdź przydzielony adres IP na ruterze
    // ustaw DEBUG na true i sprawdź otrzymywane komunikaty z modułu
    Serial.println(F("nie mogę odczytać adresu IP."));
  }

  Serial.println(F("=> Aktywuję tryb obsługi wielu połączeń (max 4)."));
  command = "AT+CIPMUX=1\r\n";
  sendData(&command, 1500, DEBUG); // włącz tryb obsługi wielu połączeń
  
  Serial.println(F("=> Tworzę serwer TCP na porcie 80."));
  command = "AT+CIPSERVER=1,80\r\n";
  sendData(&command, 1500, DEBUG); // utwórz serwer na porcie 80
}

String sendData(String *command, const int timeout, boolean debug)
{
    String response = ""; 
    esp8266.print(*command); // wyślij komendę AT do modułu WiFi
    long int time = millis();
    while( (time + timeout) > millis()) // poczekaj chwilę na odpowiedź
    {
      while(esp8266.available()) // jeśli pojawią się dane na interfejsie UART,
      {
        char c = esp8266.read(); // wstaw je do zmiennej
        response += c;
      }
    }
    if(debug) // jeśli DEBUG = true wydrukuj otrzymane dane
    {
      Serial.print(response);
    }

    // odczekaj chwilę, aby moduł WiFi przygotował się do następnej komendy AT
    delay(1000);

    return response; // zwróć odebrane dane
}
