#define BLYNK_PRINT Serial // drukuj komunikaty z platformy Blynk

// ID szablonu na platformie Blynk
#define BLYNK_TEMPLATE_ID "ID_szablonu_z_platformy_Blynk"
// indywidualny token z platformy Blynk
#define BLYNK_AUTH_TOKEN "token_z_platformy_Blynk"

#include <ESP8266WiFi.h>        // funkcje sieciowe dla układu ESP8266
#include <BlynkSimpleEsp8266.h> // obsługa platformy Blynk
#include <OneWire.h>            // obsługa interfejsu 1-wire
#include <DallasTemperature.h>  // i czujnika DS18B20

#define serialSpeed 115200      // prędkość transmisji UART

char wifi_ssid[]   = "nazwa sieci WiFi";
char wifi_passwd[] = "hasło";

#define ONE_WIRE_BUS 2          // czujnik DS18B20 podpięty do GPIO2
OneWire oneWire(ONE_WIRE_BUS);  // utwórz obiekt 1-wire
DallasTemperature ds(&oneWire); // do komunikacji z DS18B20

BlynkTimer timer; // timer dla funkcji wysyłającej dane na platformę Blynk
int blynk_vpin0  = V0; // numer wirtualnego wyprowadzenia (pinu)

const long eventTime = 10000; // wysyłaj dane co 10 sekund
float temp = 0;

void setup() 
{
  Serial.begin(serialSpeed);

  // połącz się z platformą Blynk
  Blynk.begin(BLYNK_AUTH_TOKEN, wifi_ssid, wifi_passwd);
  
  // ustaw timer dla funkcji sendTempBlynk()
  timer.setInterval(eventTime, sendTempBlynk);
}

void loop() {
  Blynk.run();
  timer.run();
}

void sendTempBlynk()
{
  Serial.println(F("Wysyłam dane na platformę Blynk"));
  temp = getTemperature(true);
  Blynk.virtualWrite(blynk_vpin0, temp);
}

float getTemperature(bool debug)
{
  ds.requestTemperatures(); // wyślij żądanie odczytu temperatury
  float tempC = ds.getTempCByIndex(0); // odczytaj wartość temperatury

  if (tempC != DEVICE_DISCONNECTED_C) { // jeśli nie pojawił się błąd
    if (debug) {
      Serial.print(F("Odczyt temperatury z urządzenia nr 1 (indeks 0): "));
      Serial.print(tempC);
      Serial.println(F("°C"));
    }
  } else { // jeśli coś poszło nie tak
    if (debug) {
      Serial.println(F("Błąd odczytu danych z urządzenia nr 1"));
    }
  }

  return tempC; // zwróć wartość temperatury
}
