<?php
date_default_timezone_set("Europe/Warsaw");

$token   = "M75xrEgR8j3p"; // token dla identyfikacji połączeń
$db_file = "database.db3"; // nazwa bazy danych

// połącz się z bazą danych SQLite
// jeśli plik z bazą nie istnieje - utwórz go
try {
    $db_pdo = new PDO('sqlite:'.__DIR__.'/'.$db_file);
    $db_pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $db_pdo->exec(
        "CREATE TABLE IF NOT EXISTS measurement
        (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            board_id INTEGER DEFAULT 0,
            temp FLOAT DEFAULT 0,
            hmd FLOAT DEFAULT 0,
            date TEXT DEFAULT (datetime('now', 'localtime'))
        );"
    );
    $db_pdo = NULL;

} catch (PDOException $e) {
    print("Błąd!: ".$e->getMessage());
    die();
}

// sprawdź, czy żądanie GET zawiera parametr "data"
if (!isset($_GET["data"])) {
    die();
}

$message = $_GET["data"];
$status = "OK";

// zdekoduj informacje z formatu JSON
$data = json_decode((string)$message, true);
if ( // jeśli dane poprawne
    json_last_error() == JSON_ERROR_NONE && 
    isset($data["token"]) && 
    $data["token"] == $token
) { 
  // zdekoduj dane i przypisz do zmiennych
  $board_id = (int)$data["board_id"];
  $temp = (float)$data["temp"];
  $hmd = (float)$data["hmd"];

  # DHT11 | 20-80%RH, 0-50℃
  $temp = round(max(min($temp, 50), 0), 2);
  $hmd = round(max(min($hmd, 80), 20), 2);

  // zapisz dane w bazie SQLite
  $db_pdo = new PDO("sqlite:".__DIR__."/".$db_file);
  $db_pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

  $stmt = $db_pdo->prepare("INSERT INTO measurement (board_id, temp, hmd) VALUES (:board_id, :temp, :hmd);");
  $stmt->bindValue(":board_id", $board_id, SQLITE3_INTEGER);
  $stmt->bindValue(":temp", $temp, SQLITE3_FLOAT);
  $stmt->bindValue(":hmd", $hmd, SQLITE3_FLOAT);
  $stmt->execute();

  $db_pdo = NULL;

} else { // jeśli dane zawierają błędy
    $status = "ERROR";
}

print($status.PHP_EOL); // zwróc status OK lub ERROR