-- tworzenie pliku tekstowego
if file.open("data.txt", "w+") then -- utwórz plik
  file.write("ESP8266!\n")          -- zapisz tekstu do pliku
  file.close()                      -- zamknij plik
end

-- dopisanie tekstu do końca pliku
if file.open("data.txt", "a") then  -- otwórz plik do zapisu
  file.write("ESP32!\n")            -- zapisz tekst na końcu pliku
  file.close()                      -- zamknij plik
end

-- odczytanie zawartości z pliku tekstowego
if file.open("data.txt", "r") then -- otwórz plik
  t1 = file.read()                 -- odczytaj zawartość pliku i wstaw do zmiennej
  file.close()                     -- zamknij plik
  print(t1)                        -- drukuj zmienną
end

-- zapisanie zmienionej treści
if file.open("data.txt", "r+") then -- otwórz plik do zapisu
  t1 = file.read()                  -- odczytaj zawartość pliku i wstaw do zmiennej
  t2 = t1:gsub("ESP8266", "ESP8266 i ESP8285") -- zmień zawartość tekstu w zmiennej t1
  file.write(t2)                               -- zapisz nową wartość do pliku
  file.close()                                 -- zamknij plik
end

-- obsługa wyjątków
function loadData() -- definicja funkcji odczytującej dane z pliku
  if file.open("data.txt", "r") then -- jeśli plik nie istnieje zgłoś wyjątek
    t1 = file.read()
    file.close()
    print(t1)
  end
end

if pcall(loadData) -- wykonaj funkcję loadData()
then
  -- blok programu, jeśli funkcja loadDate() nie spowoduje zgłoszenia wyjątku
else
  -- blok programu, jeśli zostanie zgłoszony wyjątek
  print("Plik nie istnieje!")
end