// dołącz obsługę WiFi w zależności od zastosowanego układu ESP
#if defined(ESP8266)
  #include <ESP8266WiFi.h>
#elif defined(ESP32)
  #include <WiFi.h>
#endif

#define serialSpeed 115200 // prędkość transmisji UART

char wifi_ssid[]   = "nazwa sieci WiFi";
char wifi_passwd[] = "hasło";

#include "DHT.h" // dołącz obsługę modułu DHT

/*
D2 - NodeMCU DevKit 0.9(V1)/1.0(V2)/V3 ESP-12/E
D8 - WeMos D1 R1/R2 (ESP8266)
5  - ESP-Mx DevKit (ESP8285)
8  - NodeMCU ESP-C3-12F
14 - WeMos D1 R32 (ESP-WROOM-32)
15 - NodeMCU-32-S2 ESP-12K, ESP-DevKit (ESP-WROOM-32)
*/

#define DHTPIN D2     // numer GPIO dla linii sygnałowej DAT
#define DHTTYPE DHT22 // typ czujnika DHT
/*
#define DHTTYPE DHT11
#define DHTTYPE DHT21 // DHT 21 (AM2301)
#define DHTTYPE DHT22 // DHT 22 (AM2302), AM2321
*/

DHT dht(DHTPIN, DHTTYPE); // obiekt obsługujący czujnik DHT

// obsługa połączeń z serwerem baz danych MySQL
#define MYSQL_DEBUG_PORT Serial
#define _MYSQL_LOGLEVEL_ 0

#include <MySQL_Generic.h>

#define USING_HOST_NAME true

#if USING_HOST_NAME
  char mysql_server[] = "nazwa_domeny.pl";
#else
  IPAddress mysql_server(192, 168, 1, 110);
#endif

// konfiguracja dostępu do bazy MySQL
int mysql_port      = 3306;
char mysql_user[]   = "użytkownik mysql"; 
char mysql_passwd[] = "hasło użytkownika"; 
char mysql_db[]     = "nazwa bazy danych";
char mysql_table[]  = "data"; // w naszym projekcie

// utwórz obiekt obsługujący połączenie z serwerem MySQL
MySQL_Connection conn((Client *)&client);
MySQL_Query *query_mem;

int board_id = 1; // identyfikator urządzenia

const long eventTime = 10000; // sprawdzaj dane z czujnika DHT co 10 sekund
unsigned long previousTime = eventTime;

void setup()
{
  Serial.begin(serialSpeed);

  Serial.print(F("Inicjalizacja czujnika DHT ... "));
  dht.begin();
  Serial.println(F("gotowe!"));

  // połącz z punktem dostępowym
  Serial.print(F("Łączę się z siecią WiFi "));
  WiFi.begin(wifi_ssid, wifi_passwd);

  while (WiFi.status() != WL_CONNECTED) { // czekaj na połączenie
    delay(500);
    Serial.print(F("."));
  }

  Serial.println(F(" gotowe!"));

  Serial.print(F("Aktualizacja danych na serwerze MySQL co "));
  Serial.print(eventTime / 1000);
  Serial.println(F(" sekund."));
}

void loop() 
{
  unsigned long currentTime = millis();

  // obsługa kolejnego odczytu z czujnika DHT
  if (currentTime - previousTime >= eventTime)
  { 
    previousTime = currentTime;

    float temp = dht.readTemperature();
    float hmd = dht.readHumidity();

    // jeśli odczyt z czujnika DHT jest prawidłowy, wyślij dane na serwer MySQL
    if (!(isnan(temp) || isnan(hmd)))
    {
      Serial.print(F("Odczyt danych z czujnika DHT => T: "));
      Serial.print(temp);
      Serial.print(F("°C, H: "));
      Serial.print(hmd);
      Serial.println(F("%"));

      // połącz się z serwerem MySQL
      // if (conn.connect(mysql_server, mysql_port, mysql_user, mysql_passwd))
      if (conn.connectNonBlocking(mysql_server, mysql_port, mysql_user, mysql_passwd) != RESULT_FAIL)
      {
        delay(500);
        saveDB(temp, hmd); // wyślij dane na serwer MySQL
        conn.close();
      }      
    } 
    else 
    {
      Serial.println(F("Błędny odczyt z czujnika DHT."));
    }
  }
}

void saveDB(float temp, float hmd)
{
  MySQL_Query query_mem = MySQL_Query(&conn);

  if (conn.connected())
  {
    // przygotuj instrukcję SQL
    String sql = String(F("INSERT INTO "));
    sql.concat(mysql_db);
    sql.concat(F("."));
    sql.concat(mysql_table);
    sql.concat(F("(board_id, temp, hmd) VALUES ("));
    sql.concat(board_id);
    sql.concat(F(","));
    sql.concat(temp);
    sql.concat(F(","));
    sql.concat(hmd);
    sql.concat(F(")"));

    Serial.print(F("=> Wysyłam dane na serwer MySQL ... "));

    // wykonaj instrukcję SQL
    if (query_mem.execute(sql.c_str()))
    {
      Serial.println(F("gotowe!"));
    } else {
      Serial.println(F("coś poszło nie tak, sprawdź instrukcję SQL."));
    }
  }
}
