-- ustaw moduł sieciowy w trybie klienta
wifi.setmode(wifi.STATION)

-- konfiguracja klienta
station_cfg={}
station_cfg.ssid = "nazwa sieci WiFi"
station_cfg.pwd = "hasło"
station_cfg.save = false -- nie zapisuj konfiguracji w pamięci flash
wifi.sta.config(station_cfg)
wifi.sta.connect() -- połącz się z ruterem

LEDpin = 4                      -- indeks 4 = GPIO2 dla diody LED
gpio.mode(LEDpin, gpio.OUTPUT)  -- ustaw GPIO jako wyjście

server = net.createServer(net.TCP) -- uruchom serwer TCP

-- funkcja wysyłająca kod HTML do użytkownika
function SendHTML(sck, led)
  htmlstring = "<!DOCTYPE html>\r\n"
  htmlstring = htmlstring.."<html>\r\n"
  htmlstring = htmlstring.."<head>\r\n"
  htmlstring = htmlstring.."<title>Dioda LED</title>\r\n"
  htmlstring = htmlstring.."<meta charset=\"UTF-8\">\r\n"   
  htmlstring = htmlstring.."</head>\r\n"
  htmlstring = htmlstring.."<body>\r\n"
  htmlstring = htmlstring.."<h1>Dioda LED</h1>\r\n"
  htmlstring = htmlstring.."<p>Włącz lub wyłącz diodę LED.</p>\r\n"
  htmlstring = htmlstring.."<form method=\"get\">\r\n"
  
  if (led) then -- dioda LED włączona?
   htmlstring = htmlstring.."<input type=\"button\" value=\"LED OFF\" onclick=\"window.location.href='/ledoff'\">\r\n"
  else
   htmlstring = htmlstring.."<input type=\"button\" value=\"LED ON\" onclick=\"window.location.href='/ledon'\">\r\n"
  end
  
  htmlstring = htmlstring.."</form>\r\n"
  htmlstring = htmlstring.."</body>\r\n"
  htmlstring = htmlstring.."</html>\r\n"
   
  sck:send(htmlstring) -- wyślij kod HTML do klienta serwera TCP
end

-- funkcja obsługująca klientów serwera TCP
function receiver(sck, data) -- przekaż nagłówek HTTP z żądaniem klienta
  if string.find(data, "GET /ledon")  then -- zdekoduj URL
   SendHTML(sck, true)
   gpio.write(LEDpin, gpio.HIGH)
  elseif string.find(data, "GET / ") or string.find(data, "GET /ledoff") then
   SendHTML(sck, false)
   gpio.write(LEDpin, gpio.LOW)
  else
   sck:send("<h2>Brak obsługi tego żądania</h2>")
   sck:on("sent", function(conn) conn:close() end)
  end
end

if server then -- jeśli serwer jest uruchomiony
  print("Adres IP serwera TCP: "..wifi.sta.getip())
  
  server:listen(80, function(conn) -- czekaj na klientów na porcie 80
    conn:on("receive", receiver)   -- obsłuż żądanie klienta
  end)
end