-- dołącz moduł Express
require("HttpServer")

-- ustaw moduł sieciowy w trybie klienta
wifi.setmode(wifi.STATION)

-- konfiguracja klienta
station_cfg={}
station_cfg.ssid = "nazwa sieci WiFi"
station_cfg.pwd = "hasło"
station_cfg.save = false -- nie zapisuj konfiguracji w pamięci flash
wifi.sta.config(station_cfg)
wifi.sta.connect() -- połącz się z ruterem

local port = 80             -- port serwera WWW
local mDNS = true           -- czy aktywować usługę mDNS?
local mDNSName = "nodemcu"  -- nazwa urządzenia w sieci

local dhtName = "DHT22"     -- typ czujnika DHT
local dhtPin = 2            -- numer GPIO dla linii sygnałowej DAT

-- po połączeniu się siecią WiFi wyświetl przydzielony adres IP
wifi.eventmon.register(wifi.eventmon.STA_GOT_IP, function(T)
    print("Otwórz w przeglądarce jeden z poniższych adresów URL:")
    print("http://" .. T.IP)
    if mDNS then
        mdns.register(mDNSName, {description = "Smart Home", service = "http", port = 80, location = 'Pokój 1'})
        print("http://" .. mDNSName .. ".local")
    end    
end)

-- odczyt danych z czujnika DHT
function readSensor(pin)
    str = "=> Odczyt danych z czujnika => "
    temp, hmd = 0
    status, temp, hmd, temp_dec, humi_dec = dht.read(pin)
    if status == dht.OK then
        print(str .. "T: " .. temp .. "°C, H: " .. hmd .. "%")
    elseif status == dht.ERROR_CHECKSUM or status == dht.ERROR_TIMEOUT then
        print(str .. "coś poszło nie tak :(")
    end
    return temp, hmd
end

print("Serwer WWW uruchomiony.") 

-- tworzenie obiektu aplikacji
local app = express.new()

-- definicja kodu pośredniczącego drukującego adres URL z każdym żądaniem HTTP
app:use(function(req, res, next)
    print("=> Odebrano żadanie GET " .. req.url)
    next()
end)

-- definicja obsługi żądania GET /
app:get('/', function(req, res)
    
    local fileName = "index.tpl"  -- nazwa pliku z szablonem strony
    if req.url == "/" and file.exists(fileName) then -- czy plik z szablonem istnieje?

        -- odczytanie szablonu
        local fileToServe = file.open(fileName, 'r')
        page = fileToServe:read() -- wstaw zawartość pliku do zmiennej
        fileToServe:close()
    
        -- odczyt danych z czujnika DHT podłączonego do GPIO2
        temp, hmd = readSensor(dhtPin)
        
        -- aktualizacja danych w szablonie strony
        page = page:gsub("{{ sensor }}", dhtName)
        page = page:gsub("{{ temp }}", string.format("%.1f", temp))
        page = page:gsub("{{ hmd }}", string.format("%.1f", hmd))
    
        -- wysłanie strony do klienta
        res:send(page)
    end
end)

-- uruchom serwer WWW na porcie 80
app:listen(port)