#include <Arduino.h>  // dołącz plik Arduino.h
#include "LittleFS.h" // dołącz bibliotekę obsługującą system plików LittleFS

void setup() 
{
  Serial.begin(115200); // ustaw prędkość transmisji portu szeregowego
  
  if(!LittleFS.begin()) // podmontuj system plików
  {
    Serial.println("Wystąpił błąd z zamontowaniem pamięci LittleFS");
    return;
  }
  
  File file = LittleFS.open("/dane.txt", "r"); // otwórz plik tekstowy
  if(!file)
  {
    Serial.println("Nie udało się otworzyć pliku.");
    return;
  }
  
  Serial.println("Zawartość pliku:");
  
  while(file.available())
  {
    Serial.write(file.read()); // pobierz kolejny znak z pliku i wyślij na konsolę
  }
  file.close(); // zamknij plik
}
 
void loop() {}