#define mDNS_ENABLE true         // czy aktywować usługę multicast DNS?
#define FS_ENABLE true           // czy aktywować obsługę systemu plików?

// dołącz obsługę WiFi w zależności od zastosowanego układu ESP
#if defined(ESP8266)
  #include <ESP8266WiFi.h>       // funkcje sieciowe dla układu ESP8266
  #if mDNS_ENABLE
    #include <ESP8266mDNS.h>     // włącz obsługę multicast DNS
    #define mDNS_host "esp8266"  // nazwa urządzenia w sieci lokalnej - http://esp8266.local
  #endif
#elif defined(ESP32)
  #include <WiFi.h>              // funkcje sieciowe dla układu ESP32
  #if mDNS_ENABLE
    #include <ESPmDNS.h>         // włącz obsługę multicast DNS
    #define mDNS_host "esp32"    // nazwa urządzenia w sieci lokalnej - http://esp32.local
  #endif
#endif

#if FS_ENABLE
  #include <LittleFS.h>          // dołącz obsługę systemu plików LittleFS
#endif
#include <aWOT.h>                // dołącz bibliotekę frameworku aWOT

#include "DHT.h"                 // i czujnika DHT

#define DHTPIN D2     // numer GPIO dla linii sygnałowej DAT
#define DHTTYPE DHT22 // typ czujnika DHT
/*
#define DHTTYPE DHT11
#define DHTTYPE DHT21 // DHT 21 (AM2301)
#define DHTTYPE DHT22 // DHT 22 (AM2302), AM2321
*/

DHT dht(DHTPIN, DHTTYPE); // obiekt obsługujący czujnik DHT

WiFiServer Server(80);           // utwórz obiekt serwera WWW na porcie 80
Application app;                 // i obiekt aplikacji obsługującej połączenia WWW

// dostęp do sieci WiFi
char wifi_ssid[]   = "nazwa sieci WiFi";
char wifi_passwd[] = "hasło

#define serialSpeed 115200 // prędkość transmisji UART

// obsługa żądania GET /
void pageIndex(Request &req, Response &res) {  
  Serial.print(F("=> Odebrano żądanie GET "));
  Serial.println(req.path());
  // odczytaj plik i prześlij kod HTML do klienta
  loadFromFS("/index.html", res);
}

// obsługa żądania GET /data
void getData(Request &req, Response &res) {  
  Serial.print(F("=> Odebrano żądanie GET "));
  Serial.println(req.path());
  String data = getTemperatureHumidit(true); // odczyt danych z czujnika
  res.print(data);
}

// obsługa żądań do nieistniejących adresów URL
void notFound(Request &req, Response &res) {
  res.print(F("Strona nie istnieje :("));
}

void setup()
{
  Serial.begin(serialSpeed);

  Serial.print(F("Inicjalizacja czujnika DHT ... "));
  dht.begin();
  Serial.println(F("gotowe!"));

  // połącz z punktem dostępowym
  Serial.print(F("Łączę się z siecią WiFi "));
  WiFi.begin(wifi_ssid, wifi_passwd);

  while (WiFi.status() != WL_CONNECTED) { // czekaj na połączenie
    delay(500);
    Serial.print(F("."));
  }

  Serial.println(F(" gotowe!"));

  #if mDNS_ENABLE
    // aktywuj usługę multicast DNS
    if (MDNS.begin(mDNS_host)) { 
      Serial.println(F("Usługa mDNS aktywna."));
    }
  #endif

  #if FS_ENABLE
    // aktywuj obsługę systemu plików LittleFS
    Serial.print(F("Inicjalizacja systemu plików LittleFS ..."));
    if (LittleFS.begin()) {
      Serial.println(F(" gotowe!"));
    } else {
      Serial.println(F(" coś poszło nie tak :("));
    }
  #endif

  // obsługa żądań klienta WWW przez framework aWOT
  app.get("/", &pageIndex);   // obsługa żądania HTTP GET do strony głównej
  app.get("/data", &getData); // obsługa żądania odczytu wartości z czujnika

  // metoda notFound() dostępna od wersji aWOT 3.4.0
  // app.notFound(&notFound);    // obsługa żądań do nieistniejących adresów URL
  
  Server.begin();             // uruchom serwer WWW
  
  Serial.println(F("Serwer WWW uruchomiony."));
  Serial.println(F("Otwórz w przeglądarce jeden z poniższych adresów URL:"));
  Serial.print(F("=> http://"));
  Serial.println(WiFi.localIP());
  #if mDNS_ENABLE
    Serial.print(F("=> http://"));
    Serial.print(mDNS_host);
    Serial.println(F(".local"));
  #endif
}

void loop() 
{
  WiFiClient client = Server.available();

  if (client.connected()) { // czekaj na połączenia klientów
    app.process(&client);   // obsłuż żądanie klienta
    client.stop();          // i zamknij połączenie
  }

  #if defined(ESP8266)
    MDNS.update();          // aktualizuj nazwę urządzenia w sieci lokalnej
  #endif
}

// odczytanie pliku z pamięci i wysłanie do użytkownika
bool loadFromFS(String path, Response &res) 
{
  Serial.print(F("=> Odczytuję z pamięci plik "));
  Serial.print(path);
  if (LittleFS.exists(path))
  {
    File dataFile = LittleFS.open(path, "r"); // otwórz plik
    
    if (!dataFile) {
      return false;
    }
    
    res.set("Content-Type", "text/html");     // typ wysyłanych danych

    while (dataFile.available()) {            // wyślij plik
      res.write(dataFile.read());             
    }

    res.end();                                // zakończ połączenie
    dataFile.close();                         // zamknij plik

    Serial.println(F(" ... gotowe!"));
  } else {
    return false;
  }
  return true;
}

// odczyt danych z czujnika
String getTemperatureHumidit(bool debug)
{
  float temp = dht.readTemperature();
  float hmd = dht.readHumidity();

  if (!(isnan(temp) || isnan(hmd))){
    if (debug)
    {
      Serial.print(F("Odczyt danych z czujnika DHT => T: "));
      Serial.print(temp);
      Serial.print(F("°C, H: "));
      Serial.print(hmd);
      Serial.println(F("%"));
    }
  } else {
    temp = 0;
    hmd = 0;
    Serial.println(F("Błędny odczyt z czujnika DHT."));
  }
    
  String data = String(temp) + String(",") + String(hmd);
  return data; // zwróć wartość temperatury i wilgotności
}