-- ustaw moduł sieciowy w trybie klienta
wifi.setmode(wifi.STATION)

-- konfiguracja klienta
station_cfg={}
station_cfg.ssid="nazwa sieci WiFi"
station_cfg.pwd="hasło"
station_cfg.save = false -- nie zapisuj konfiguracji w pamięci flash
wifi.sta.config(station_cfg)
wifi.sta.connect() -- połącz się z ruterem

server = net.createServer(net.TCP) -- uruchom serwer TCP

-- funkcja obsługująca klientów serwera TCP
function receiver(sck, data)

  -- tablica z numeracją GPIO dla układu ESP8266
  local esp8266gpio = { 16, 5, 4, 0, 2, 14, 12, 13, 15, 3, 1, 9, 10 }
  
  htmlstring = "<!DOCTYPE html>\r\n"
  htmlstring = htmlstring.."<html>\r\n"
  htmlstring = htmlstring.."<head>\r\n"
  htmlstring = htmlstring.."<title>ESP8266 GPIO</title>\r\n"
  htmlstring = htmlstring.."<meta charset=\"UTF-8\">\r\n"   
  htmlstring = htmlstring.."</head>\r\n"
  htmlstring = htmlstring.."<body>\r\n"
  htmlstring = htmlstring.."<h1>ESP8266 GPIO</h1>\r\n"
  htmlstring = htmlstring.."<table border=\"1\">\r\n"
  htmlstring = htmlstring.."<tr><th>Index</th><th>ESP8266</th><th>Stan</th></tr>\r\n"

  -- odczytaj stany wszystkich GPIO i wstaw je do kodu HTML
  for i = 0, 12, 1 do
    local esp = "GPIO"..esp8266gpio[i+1] -- odczytaj numer GPIO dla ESP8266
    local state = gpio.read(i) -- odczytaj stan GPIO
    htmlstring = htmlstring.."<tr><td>"..i.."</td><td>"..esp.."</td><td>"..state.."</td></tr>\r\n"
  end
   
  htmlstring = htmlstring.."</table>\r\n"
  htmlstring = htmlstring.."</body>\r\n"
  htmlstring = htmlstring.."</html>\r\n"
   
  sck:send(htmlstring) -- wyślij kod HTML do strumienia
  sck:on("sent", function(conn) conn:close() end)
end

if server then -- jeśli serwer jest uruchomiony
  print("Adres IP serwera TCP: "..wifi.sta.getip())
  
  server:listen(80, function(conn) -- czekaj na klientów na porcie 80
    conn:on("receive", receiver)   -- obsłuż żądanie klienta
  end)
end