// dołącz obsługę WiFi w zależności od zastosowanego układu ESP
#if defined(ESP8266)
  #include <ESP8266WiFi.h>
#elif defined(ESP32)
  #include <WiFi.h>
#endif

#define serialSpeed 115200 // prędkość transmisji UART

char wifi_ssid[]   = "nazwa sieci WiFi";
char wifi_passwd[] = "hasło";

#include "DHT.h" // dołącz obsługę modułu DHT

/*
D2 - NodeMCU DevKit 0.9(V1)/1.0(V2)/V3 ESP-12/E
D8 - WeMos D1 R1/R2 (ESP8266)
5  - ESP-Mx DevKit (ESP8285)
8  - NodeMCU ESP-C3-12F
14 - WeMos D1 R32 (ESP-WROOM-32)
15 - NodeMCU-32-S2 ESP-12K, ESP-DevKit (ESP-WROOM-32)
*/

#define DHTPIN D2     // numer GPIO dla linii sygnałowej DAT
#define DHTTYPE DHT22 // typ czujnika DHT
/*
#define DHTTYPE DHT11
#define DHTTYPE DHT21 // DHT 21 (AM2301)
#define DHTTYPE DHT22 // DHT 22 (AM2302), AM2321
*/

DHT dht(DHTPIN, DHTTYPE); // obiekt obsługujący czujnik DHT

// obsługa klienta serwera FTP
#define DEBUG_ETHERNET_WEBSERVER_PORT Serial
#define _FTP_LOGLEVEL_ 0
#define USING_VSFTP_SERVER true

#include <FTPClient_Generic.h>

char ftp_server[]   = "adres serwera FTP";
char ftp_user[]     = "użytkownik ftp";
char ftp_passwd[]   = "hasło użytkownika ftp";
char ftp_dirName[]  = "/";
char ftp_fileName[] = "data.txt";

// utwórz obiekt obsługujący połączenie z serwerem FTP
FTPClient_Generic ftp (ftp_server, ftp_user, ftp_passwd, 60000);

int board_id = 1; // identyfikator urządzenia

const long eventTime = 10000; // sprawdzaj dane z czujnika DHT co 10 sekund
unsigned long previousTime = eventTime;

void setup()
{
  Serial.begin(serialSpeed);

  Serial.print(F("Inicjalizacja czujnika DHT ... "));
  dht.begin();
  Serial.println(F("gotowe!"));

  // połącz z punktem dostępowym
  Serial.print(F("Łączę się z siecią WiFi "));
  WiFi.begin(wifi_ssid, wifi_passwd);

  while (WiFi.status() != WL_CONNECTED) { // czekaj na połączenie
    delay(500);
    Serial.print(F("."));
  }

  Serial.println(F(" gotowe!"));

  Serial.print(F("Aktualizacja danych na serwerze FTP co "));
  Serial.print(eventTime / 1000);
  Serial.println(F(" sekund."));
}

void loop() 
{
  unsigned long currentTime = millis();

  // obsługa kolejnego odczytu z czujnika DHT
  if (currentTime - previousTime >= eventTime)
  { 
    previousTime = currentTime;

    float temp = dht.readTemperature();
    float hmd = dht.readHumidity();

    // jeśli odczyt z czujnika DHT jest prawidłowy, wyślij dane na serwer FTP
    if (!(isnan(temp) || isnan(hmd)))
    {
      Serial.print(F("Odczyt danych z czujnika DHT => T: "));
      Serial.print(temp);
      Serial.print(F("°C, H: "));
      Serial.print(hmd);
      Serial.println(F("%"));

      // zapisz dane w pliku tekstowym na serwerze FTP
      saveFTP(temp, hmd);
    } 
    else 
    {
      Serial.println(F("Błędny odczyt z czujnika DHT."));
    }
  }
}

void saveFTP(float temp, float hmd)
{
  String data = String(board_id);
  data.concat(F(","));
  data.concat(temp);
  data.concat(F(","));
  data.concat(hmd);
  data.concat(F("\n"));

  Serial.print(F("=> Wysyłam dane na serwer FTP ... "));

  ftp.OpenConnection();                    // otwórz połączenie z serwerem FTP
  if (ftp.isConnected())                   // i sprawdź jego stan
  {
    ftp.ChangeWorkDir(ftp_dirName);        // zmień lokalizację zapisu danych do pliku

    ftp.InitFile(COMMAND_XFER_TYPE_ASCII); // tryb pliku tekstowego
    ftp.AppendFile(ftp_fileName);          // otwórz plik w trybie do zapisu
    ftp.Write(data.c_str());               // zapisz dane na końcu pliku
    ftp.CloseFile();                       // zakmnij dostęp do pliku

    ftp.CloseConnection();                 // zamknij połączenie z serwerem FTP

    Serial.println(F("gotowe!"));
  } else {
    Serial.println(F("coś poszło nie tak, sprawdź konfigurację FTP."));
  }
}
