#include <SoftwareSerial.h> // dołącz obsługę UART dla pozostałych wyprowadzeń
#include "DHT.h"            // i obsługę czujnika DHT

#define serialSpeed 115200 // prędkość transmisji UART
#define DEBUG false        // true drukuje otrzymane dane z UART

SoftwareSerial esp8266(2,3); // RX, TX

char wifi_ssid[]   = "nazwa sieci WiFi";
char wifi_passwd[] = "hasło";

// żądanie GET wysyłane do serwera Blynk
char blynk_get[]     = "GET /external/api/batch/update?token=";
// adres IP i port serwera Blynk
char blynk_ip[]      = "46.101.217.214";
char blynk_port[]    = "80";
// indywidualny token z platformy Blynk
char blynk_token[]   = "token_z_platformy_Blynk";
// nazwy wirtualnych wyprowadzeń (pinów) w serwisie Blynk
char blynk_vpin0[]   = "V0";
char blynk_vpin1[]   = "V1";

const long eventTime = 60000; // 60 sekund
unsigned long previousTime = eventTime; // pierwszy pakiet wyślij po starcie programu

#define DHTPIN 7      // numer GPIO dla linii sygnałowej DAT w DHT11
#define DHTTYPE DHT11 // typ czujnika DHT

DHT dht(DHTPIN, DHTTYPE); // obiekt obsługujący czujnik DHT

void setup() {
  // prędkość komunikacji na interfejsach UART
  Serial.begin(serialSpeed);
  esp8266.begin(serialSpeed); 

  Serial.print(F("Inicjalizacja czujnika DHT ... "));
  dht.begin(); // aktywuj odczyt z czujnika DHT
  Serial.println(F("gotowe!"));

  Serial.println(F("Inicjalizacja modułu WiFi"));
  InitWifiModule(); // aktywuj moduł WiFi w trybie klienta
  Serial.println(F("Moduł gotowy do wysyłania danych na platformę Blynk ..."));
}

void loop() {
  unsigned long currentTime = millis();

  if (currentTime - previousTime >= eventTime)
  { 
    previousTime = currentTime;

    float temp = dht.readTemperature();
    float hmd = dht.readHumidity();

    Serial.print(F("T: "));
    Serial.print(temp);
    Serial.print(F("°C, H: "));
    Serial.print(hmd);
    Serial.print(F("% | wysyłam dane na platformę Blynk ... "));

    updateBlynk(temp, hmd); // wyślij dane na platformę Blynk

    Serial.println(F("gotowe!"));
  }
}

void updateBlynk(float temp, float hmd)
{
  // przygotuj polecenie do połączenia się z serwerem Blynk
  String tcp = "AT+CIPSTART=\"TCP\",\"";
  tcp.concat(blynk_ip);
  tcp.concat("\",");
  tcp.concat(blynk_port);
  tcp.concat("\r\n");

  // otwórz połączenie TCP z serwerem Blynk
  sendData(&tcp, 3000, DEBUG);

  // przygotuj żądanie GET z parametrami czujników
  String request = blynk_get;
  request.concat(blynk_token);
  request.concat("&");
  request.concat(blynk_vpin0);
  request.concat("=");
  request.concat(temp);
  request.concat("&");
  request.concat(blynk_vpin1);
  request.concat("=");
  request.concat(hmd);
  request.concat(" HTTP/1.1\r\n");
  request.concat("Connection: Close\r\n");
  request.concat("\r\n");

  // przygotuj żądanie GET do wysłania
  String cipSend = "AT+CIPSEND=";
  cipSend.concat(request.length());
  cipSend.concat("\r\n");
  sendData(&cipSend, 1000, DEBUG);

  // wyślij żądanie GET na serwer Blynk
  sendData(&request, 3000, DEBUG);
}

void InitWifiModule()
{
  String command = "";
  // sendData("AT+RESTORE\r\n", 2000, DEBUG); // przywrócenie ustawień domyślnych

  command = "AT+RST\r\n";
  sendData(&command, 2000, DEBUG); // reset modułu WiFi
  
  Serial.println(F("=> Ustawiam moduł w trybie klienta."));
  command = "AT+CWMODE=1\r\n";
  sendData(&command, 1500, DEBUG); // tryb klienta

  // przygotuj polecenie do połaczenia się z siecią WiFi
  Serial.println(F("=> Łączę moduł z siecią WiFi."));
  String cwjap = "AT+CWJAP=\"";
  cwjap.concat(wifi_ssid);
  cwjap.concat("\",\"");
  cwjap.concat(wifi_passwd);
  cwjap.concat("\"\r\n");
  sendData(&cwjap, 3000, DEBUG); // połącz z siecią WiFi

  delay(5000); // poczekaj, aż moduł WiFi połączy się z punktem dostępowym
}

String sendData(String *command, const int timeout, boolean debug)
{
    String response = ""; 
    esp8266.print(*command); // wyślij komendę AT do modułu WiFi
    long int time = millis();
    while( (time + timeout) > millis()) // poczekaj chwilę na odpowiedź
    {
      while(esp8266.available()) // jeśli pojawią się dane na interfejsie UART,
      {
        char c = esp8266.read(); // wstaw je do zmiennej
        response += c;
      }
    }
    if(debug) // jeśli DEBUG = true wydrukuj otrzymane dane
    {
      Serial.print(response);
    }

    // odczekaj chwilę, aby moduł WiFi przygotował się do następnej komendy AT
    delay(1000);

    return response; // zwróć odebrane dane
}
