-- ustaw modul sieciowy w trybie klienta
wifi.setmode(wifi.STATION)

-- konfiguracja klienta
station_cfg = {}
station_cfg.ssid = "nazwa sieci WiFi"
station_cfg.pwd = "hasło"
station_cfg.save = false -- nie zapisuj konfiguracji w pamięci flash
wifi.sta.config(station_cfg) -- połącz z siecią WiFi

-- funkcja obsługująca tablicę z listą dostępnych sieci
function listap(t)
  for bssid,v in pairs(t) do -- rozdziel dane z tablicy t
    -- utwórz zmienne lokalne i przypisz im wartości z tablicy v
    local ssid, rssi, authmode, channel = 
      string.match(v, "([^,]+),([^,]+),([^,]+),([^,]*)")
    -- drukuj BSSID, SSID i kanał
    print(bssid.." : "..ssid.." : "..channel)
  end
end

-- pobierz listę dostępnych sieci i wynik przekaż do funkcji listap()
wifi.sta.getap(1, listap) -- pobierz dane w nowym formacie