#include <ESP8266WiFi.h>       // funkcje sieciowe dla układu ESP8266
#include <ESP8266WebServer.h>  // serwer WWW z obsługą żądań HTTP GET i POST
#include <ESP8266mDNS.h>       // włącz obsługę multicast DNS

#define serialSpeed 115200     // prędkość transmisji UART
#define pinRelay 0             // przekaźnik podłączony do GPIO0

char wifi_ssid[]   = "nazwa sieci WiFi";
char wifi_passwd[] = "hasło";

ESP8266WebServer Server(80); // obiekt serwera WWW na porcie 80

char* mDNS_host = "esp8266"; // nazwa hosta w sieci lokalnej

int statusRelay = 0;

// kod HTML strony startowej zapisany w pamięci programu (nie w pamięci RAM)
const char page_index[] PROGMEM = R"=====(
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<title>Mój Smart Home</title>
<style>
body { padding: 2rem; }
h1 { font-size: 2rem; }
h2 { font-size: 1rem; }
.item { font-size: 2.5rem; }
.item span { font-weight: bold; }
.on { color: #27AE60; }
.off { color: #C0392B; }
</style>
</head>
<body>
<h1>Mój Smart Home</h1>
<h2>Obsługa przekaźnika</h2>
<p class="item">Przekaźnik jest <span id="status"></span></p>
<hr>
<p><button onclick="relay('on')">Włącz przekaźnik</button></p>
<p><button onclick="relay('off')">Wyłącz przekaźnik</button></p>
</body>
<script>
function relay(action){
 var xhttp = new XMLHttpRequest();
 xhttp.onreadystatechange = function(){
  if (this.readyState == 4 && this.status == 200){
    data = this.responseText;
    el = document.getElementById('status');
    el.innerHTML = (data == 1) ? 'włączony' : 'wyłączony';
    el.className = (data == 1) ? 'on' : 'off';
  }
 };
 xhttp.open('GET', '/'+action, true);
 xhttp.send();
};
relay('status')
</script>
</html>
)=====";

void setup() 
{
  Serial.begin(serialSpeed);

  pinMode(pinRelay, OUTPUT);
  digitalWrite(pinRelay, HIGH);

  // połącz z punktem dostępowym
  Serial.print(F("Łączę się z siecią WiFi "));
  WiFi.begin(wifi_ssid, wifi_passwd);

  while (WiFi.status() != WL_CONNECTED) { // czekaj na połączenie
    delay(500);
    Serial.print(F("."));
  }

  Serial.println(F(" gotowe!"));

  // aktywuj usługę multicast DNS
  if (MDNS.begin(mDNS_host)) { 
    Serial.println(F("Usługa mDNS aktywna."));
  }

  // uruchom serwer WWW
  Server.begin();
  Serial.println(F("Serwer WWW uruchomiony."));
  Serial.println(F("Otwórz w przeglądarce jeden z poniższych adresów URL:"));
  Serial.print(F("=> http://"));
  Serial.println(WiFi.localIP());
  Serial.print(F("=> http://"));
  Serial.print(mDNS_host);
  Serial.println(F(".local"));

  // obsługa adresów URL
  Server.on("/", handleRoot);              // URL strony głównej
  Server.on("/on", handleRelayOn);         // włącz przekaźnik
  Server.on("/off", handleRelayOff);       // wyłącz przekaźnik
  Server.on("/status", handleRelayStatus); // status przekaźnika
  Server.onNotFound(handleNotFound);       // obsługa błędu HTTP 404
}

void loop() 
{
  Server.handleClient(); // czekaj na połączenia klientów
  MDNS.update();
}

// obsługa wywołania URL strony głównej
void handleRoot()
{
  Serial.println(F("Odebrano żądanie GET /"));
  Server.send(200, "text/html", page_index);
}

// obsługa URL włączającego przekaźnik
void handleRelayOn()
{
  Serial.println(F("Odebrano żądanie GET /on"));
  statusRelay = 1;
  digitalWrite(pinRelay, LOW); // włącz stanem niskim
  Server.send(200, "text/plain", "1");
}

// obsługa URL wyłączającego przekaźnik
void handleRelayOff()
{
  Serial.println(F("Odebrano żądanie GET /off"));
  statusRelay = 1;
  digitalWrite(pinRelay, HIGH); // wyłącz stanem wysokim
  Server.send(200, "text/plain", "0");
}

// obsługa URL zwracającego status przekaźnika
void handleRelayStatus()
{
  Serial.println(F("=> Odebrano żądanie GET /status"));
  Server.send(200, "text/plain", String(statusRelay));
}

// obsługa błędu HTTP 404
void handleNotFound() 
{
  String message = "404 Not Found\n\n";
  message += "The request ";
  message += Server.uri();
  message += " was not found on this server.\n";
  message += "\nMethod: ";
  message += (Server.method() == HTTP_GET) ? "GET" : "POST";
  message += "\nArguments: ";
  message += Server.args();
  message += "\n";
  for (int i = 0; i < Server.args(); i++)
  {
    message += " " + Server.argName(i) + ": " + Server.arg(i) + "\n";
  }
  Server.send(404, "text/plain", message);
}
