#include <WiFi.h> // funkcje sieciowe dla układu ESP32
#include <aWOT.h> // dołącz bibliotekę aWOT

WiFiServer Server(80); // utwórz obiekt serwera WWW na porcie 80
Application app;       // i obiekt aplikacji obsługującej połączenia WWW

void index(Request &req, Response &res) { // obsługa żądania GET /
  res.print("Serwer WWW aktywny!");
}

void setup() {
  Serial.begin(115200);

  WiFi.begin("nazwa sieci WiFi", "hasło");
  while (WiFi.status() != WL_CONNECTED) { // czekaj na połączenie
    delay(500);
    Serial.print(".");
  }
  Serial.println(WiFi.localIP());

  app.get("/", &index); // obsługa żądania GET /
  Server.begin();       // uruchom serwer WWW
}

void loop() {
  WiFiClient client = Server.available();
  if (client.connected()) { // czekaj na połączenia klientów
    app.process(&client);   // obsłuż żądanie klienta
  }
}
