#define BLYNK_PRINT Serial // drukuj komunikaty z platformy Blynk

// ID szablonu na platformie Blynk
#define BLYNK_TEMPLATE_ID "ID_szablonu_z_platformy_Blynk"
// indywidualny token z platformy Blynk
#define BLYNK_AUTH_TOKEN "token_z_platformy_Blynk"

#include <ESP8266WiFi.h>        // funkcje sieciowe dla układu ESP8266
#include <BlynkSimpleEsp8266.h> // obsługa platformy Blynk
#include "DHT.h"                // i czujnika DHT

#define serialSpeed 115200      // prędkość transmisji UART

char wifi_ssid[]   = "nazwa sieci WiFi";
char wifi_passwd[] = "hasło";

#define DHTPIN 2      // numer GPIO dla linii sygnałowej DAT w DHT11
#define DHTTYPE DHT11 // typ czujnika DHT
/*
#define DHTTYPE DHT21 // DHT 21 (AM2301)
#define DHTTYPE DHT22 // DHT 22 (AM2302), AM2321
*/

DHT dht(DHTPIN, DHTTYPE); // obiekt obsługujący czujnik DHT

BlynkTimer timer; // timer dla funkcji wysyłającej dane na platformę Blynk
int blynk_vpin0  = V0; // numer wirtualnego wyprowadzenia (pinu)
int blynk_vpin1  = V1; // jw.

const long eventTime = 10000; // wysyłaj dane co 10 sekund

// prosta struktura danych do przechowywania
// wartości temperatury i wilgotności
struct meas
{
  float temp;
  float hmd;
};

void setup() 
{
  Serial.begin(serialSpeed);

  // Inicjalizacja czujnika DHT11
  dht.begin();

  // połącz się z platformą Blynk
  Blynk.begin(BLYNK_AUTH_TOKEN, wifi_ssid, wifi_passwd);
  
  // ustaw timer dla funkcji sendTempBlynk()
  timer.setInterval(eventTime, sendTempBlynk);
}

void loop() 
{
  Blynk.run();
  timer.run();
}

void sendTempBlynk()
{
  Serial.println(F("Wysyłam dane na platformę Blynk"));
  meas data = getTemperatureHumidit(true);
  Blynk.virtualWrite(blynk_vpin0, data.temp);
  Blynk.virtualWrite(blynk_vpin1, data.hmd);
}

meas getTemperatureHumidit(bool debug)
{
  float temp = dht.readTemperature();
  float hmd = dht.readHumidity();

  if (debug)
  {
    Serial.print(F("Odczyt danych z czujnika DHT11 => T: "));
    Serial.print(temp);
    Serial.print(F("°C, H: "));
    Serial.print(hmd);
    Serial.println(F("%"));
  }

  // wstaw wartości odczytów do struktury danych
  meas data;
  data.temp = temp;
  data.hmd = hmd;

  return data; // zwróć wartość temperatury i wilgotności
}
