/*
 * Decompiled with CFR 0.152.
 */
package com.esp32.mkspiffs;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JOptionPane;
import org.apache.commons.codec.digest.DigestUtils;
import processing.app.BaseNoGui;
import processing.app.Editor;
import processing.app.PreferencesData;
import processing.app.Sketch;
import processing.app.debug.TargetPlatform;
import processing.app.helpers.FileUtils;
import processing.app.helpers.ProcessUtils;
import processing.app.tools.Tool;

public class ESP32FS
implements Tool {
    Editor editor;

    public void init(Editor editor) {
        this.editor = editor;
    }

    public String getMenuTitle() {
        return "ESP32 Sketch Data Upload";
    }

    private int listenOnProcess(String[] stringArray) {
        try {
            final Process process = ProcessUtils.exec((String[])stringArray);
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        int n;
                        InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
                        while ((n = inputStreamReader.read()) != -1) {
                            System.out.print((char)n);
                        }
                        inputStreamReader.close();
                        inputStreamReader = new InputStreamReader(process.getErrorStream());
                        while ((n = inputStreamReader.read()) != -1) {
                            System.err.print((char)n);
                        }
                        inputStreamReader.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            thread.start();
            int n = process.waitFor();
            thread.join();
            return n;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private void sysExec(final String[] stringArray) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    if (ESP32FS.this.listenOnProcess(stringArray) != 0) {
                        ESP32FS.this.editor.statusError("SPIFFS Upload failed!");
                    } else {
                        ESP32FS.this.editor.statusNotice("SPIFFS Image Uploaded");
                    }
                }
                catch (Exception exception) {
                    ESP32FS.this.editor.statusError("SPIFFS Upload failed!");
                }
            }
        };
        thread.start();
    }

    private String getBuildFolderPath(Sketch sketch) {
        try {
            String string = sketch.getBuildPath().getAbsolutePath();
            return string;
        }
        catch (IOException iOException) {
            this.editor.statusError((Exception)iOException);
        }
        catch (Exception exception) {
            try {
                File file = FileUtils.createTempFolder((String)"build", (String)(DigestUtils.md5Hex((String)sketch.getMainFilePath()) + ".tmp"));
                return file.getAbsolutePath();
            }
            catch (IOException iOException) {
                this.editor.statusError((Exception)iOException);
            }
            catch (Exception exception2) {
                try {
                    Method method = BaseNoGui.class.getMethod("getBuildFolder", new Class[0]);
                    File file = (File)method.invoke(null, new Object[0]);
                    return file.getAbsolutePath();
                }
                catch (SecurityException securityException) {
                    this.editor.statusError((Exception)securityException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.editor.statusError((Exception)illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    this.editor.statusError((Exception)invocationTargetException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    this.editor.statusError((Exception)noSuchMethodException);
                }
            }
        }
        return "";
    }

    private long parseInt(String string) {
        if (string.startsWith("0x")) {
            return Long.parseLong(string.substring(2), 16);
        }
        return Integer.parseInt(string);
    }

    private long getIntPref(String string) {
        String string2 = (String)BaseNoGui.getBoardPreferences().get((Object)string);
        if (string2 == null || string2.contentEquals("")) {
            return 0L;
        }
        return this.parseInt(string2);
    }

    private void createAndUpload() {
        File[] fileArray;
        Object object2;
        String string;
        Object object3;
        long l = 0L;
        long l2 = 0L;
        long l3 = 256L;
        long l4 = 4096L;
        String string2 = "";
        if (!PreferencesData.get((String)"target_platform").contentEquals("esp32")) {
            System.err.println();
            this.editor.statusError("SPIFFS Not Supported on " + PreferencesData.get((String)"target_platform"));
            return;
        }
        TargetPlatform targetPlatform = BaseNoGui.getTargetPlatform();
        String string3 = ".py";
        if (PreferencesData.get((String)"runtime.os").contentEquals("windows")) {
            string3 = ".exe";
        } else if (PreferencesData.get((String)"runtime.os").contentEquals("macosx")) {
            string3 = "";
        }
        String string4 = PreferencesData.get((String)"runtime.os").contentEquals("windows") ? "python.exe" : "python";
        String string5 = PreferencesData.get((String)"runtime.os").contentEquals("windows") ? "mkspiffs.exe" : "mkspiffs";
        String string6 = "espota.py";
        if (PreferencesData.get((String)"runtime.os").contentEquals("windows")) {
            string6 = "espota.exe";
        }
        Boolean bl = false;
        File file = new File(targetPlatform.getFolder() + "/tools");
        File file2 = new File(targetPlatform.getFolder() + "/tools");
        String string7 = PreferencesData.get((String)"serial.port");
        if (!BaseNoGui.getBoardPreferences().containsKey((Object)"build.partitions")) {
            System.err.println();
            this.editor.statusError("Partitions Not Defined for " + (String)BaseNoGui.getBoardPreferences().get((Object)"name"));
            return;
        }
        try {
            string2 = (String)BaseNoGui.getBoardPreferences().get((Object)"build.partitions");
            if (string2 == null || string2.contentEquals("")) {
                this.editor.statusError("Partitions Not Found for " + (String)BaseNoGui.getBoardPreferences().get((Object)"name"));
                return;
            }
        }
        catch (Exception exception) {
            this.editor.statusError(exception);
            return;
        }
        File file3 = new File(targetPlatform.getFolder() + "/tools/partitions", string2 + ".csv");
        if (!file3.exists() || !file3.isFile()) {
            System.err.println();
            this.editor.statusError("SPIFFS Error: partitions file " + string2 + ".csv not found!");
            return;
        }
        try {
            object3 = new BufferedReader(new FileReader(file3));
            string = "";
            while ((string = ((BufferedReader)object3).readLine()) != null) {
                if (!string.contains("spiffs")) continue;
                string = string.substring(string.indexOf(",") + 1);
                string = string.substring(string.indexOf(",") + 1);
                string = string.substring(string.indexOf(",") + 1);
                while (string.startsWith(" ")) {
                    string = string.substring(1);
                }
                object2 = string.substring(0, string.indexOf(","));
                string = string.substring(string.indexOf(",") + 1);
                while (string.startsWith(" ")) {
                    string = string.substring(1);
                }
                fileArray = string.substring(0, string.indexOf(","));
                l = this.parseInt((String)object2);
                l2 = this.parseInt((String)fileArray);
            }
            if (l2 == 0L) {
                System.err.println();
                this.editor.statusError("SPIFFS Error: partition size could not be found!");
                return;
            }
        }
        catch (Exception exception) {
            this.editor.statusError(exception);
            return;
        }
        object3 = new File(targetPlatform.getFolder() + "/tools", string5);
        if (!(((File)object3).exists() && ((File)object3).isFile() || ((File)(object3 = new File(targetPlatform.getFolder() + "/tools/mkspiffs", string5))).exists() || ((File)(object3 = new File(PreferencesData.get((String)"runtime.tools.mkspiffs.path"), string5))).exists())) {
            System.err.println();
            this.editor.statusError("SPIFFS Error: mkspiffs not found!");
            return;
        }
        if (string7 == null || string7.isEmpty()) {
            System.err.println();
            this.editor.statusError("SPIFFS Error: serial port not defined!");
            return;
        }
        if (string7.split("\\.").length == 4) {
            bl = true;
            file = new File(targetPlatform.getFolder() + "/tools", string6);
            if (!file.exists() || !file.isFile()) {
                System.err.println();
                this.editor.statusError("SPIFFS Error: espota not found!");
                return;
            }
        } else {
            string = "esptool" + string3;
            file2 = new File(targetPlatform.getFolder() + "/tools", string);
            if (!(file2.exists() && file2.isFile() || (file2 = new File(targetPlatform.getFolder() + "/tools/esptool_py", string)).exists() || (file2 = new File(PreferencesData.get((String)"runtime.tools.esptool_py.path"), string)).exists())) {
                System.err.println();
                this.editor.statusError("SPIFFS Error: esptool not found!");
                return;
            }
        }
        int n = 0;
        object2 = new File(this.editor.getSketch().getFolder(), "data");
        if (!((File)object2).exists()) {
            ((File)object2).mkdirs();
        }
        if (((File)object2).exists() && ((File)object2).isDirectory() && (fileArray = ((File)object2).listFiles()).length > 0) {
            for (File object4 : fileArray) {
                if (!object4.isDirectory() && !object4.isFile() || object4.getName().startsWith(".")) continue;
                ++n;
            }
        }
        fileArray = ((File)object2).getAbsolutePath();
        File[] fileArray2 = ((File)object3).getAbsolutePath();
        String string8 = this.editor.getSketch().getName();
        String string9 = this.getBuildFolderPath(this.editor.getSketch()) + "/" + string8 + ".spiffs.bin";
        String string10 = (String)BaseNoGui.getBoardPreferences().get((Object)"upload.speed");
        Object[] objectArray = new Object[]{"Yes", "No"};
        String string11 = "SPIFFS Create";
        String string12 = "No files have been found in your data folder!\nAre you sure you want to create an empty SPIFFS image?";
        if (n == 0 && JOptionPane.showOptionDialog((Component)this.editor, string12, string11, 0, 3, null, objectArray, objectArray[1]) != 0) {
            System.err.println();
            this.editor.statusError("SPIFFS Warning: mkspiffs canceled!");
            return;
        }
        this.editor.statusNotice("SPIFFS Creating Image...");
        System.out.println("[SPIFFS] data   : " + (String)fileArray);
        System.out.println("[SPIFFS] start  : " + l);
        System.out.println("[SPIFFS] size   : " + l2 / 1024L);
        System.out.println("[SPIFFS] page   : " + l3);
        System.out.println("[SPIFFS] block  : " + l4);
        try {
            if (this.listenOnProcess(new String[]{fileArray2, "-c", fileArray, "-p", l3 + "", "-b", l4 + "", "-s", l2 + "", string9}) != 0) {
                System.err.println();
                this.editor.statusError("SPIFFS Create Failed!");
                return;
            }
        }
        catch (Exception string122) {
            this.editor.statusError(string122);
            this.editor.statusError("SPIFFS Create Failed!");
            return;
        }
        this.editor.statusNotice("SPIFFS Uploading Image...");
        System.out.println("[SPIFFS] upload : " + string9);
        if (bl.booleanValue()) {
            System.out.println("[SPIFFS] IP     : " + string7);
            System.out.println();
            if (file.getAbsolutePath().endsWith(".py")) {
                this.sysExec(new String[]{string4, file.getAbsolutePath(), "-i", string7, "-p", "3232", "-s", "-f", string9});
            } else {
                this.sysExec(new String[]{file.getAbsolutePath(), "-i", string7, "-p", "3232", "-s", "-f", string9});
            }
        } else {
            String string13 = (String)BaseNoGui.getBoardPreferences().get((Object)"build.flash_mode");
            String string14 = (String)BaseNoGui.getBoardPreferences().get((Object)"build.flash_freq");
            System.out.println("[SPIFFS] address: " + l);
            System.out.println("[SPIFFS] port   : " + string7);
            System.out.println("[SPIFFS] speed  : " + string10);
            System.out.println("[SPIFFS] mode   : " + string13);
            System.out.println("[SPIFFS] freq   : " + string14);
            System.out.println();
            if (file2.getAbsolutePath().endsWith(".py")) {
                this.sysExec(new String[]{string4, file2.getAbsolutePath(), "--chip", "esp32", "--baud", string10, "--port", string7, "--before", "default_reset", "--after", "hard_reset", "write_flash", "-z", "--flash_mode", string13, "--flash_freq", string14, "--flash_size", "detect", "" + l, string9});
            } else {
                this.sysExec(new String[]{file2.getAbsolutePath(), "--chip", "esp32", "--baud", string10, "--port", string7, "--before", "default_reset", "--after", "hard_reset", "write_flash", "-z", "--flash_mode", string13, "--flash_freq", string14, "--flash_size", "detect", "" + l, string9});
            }
        }
    }

    public void run() {
        this.createAndUpload();
    }
}

