CREATE FUNCTION SalesLT.RegionsOfTopSalesPersons (@persons int)
RETURNS @Regions TABLE (StateProvince nvarchar(50),
                        CountryRegion nvarchar(50))
BEGIN
  DECLARE @TopSalesPersons TABLE (SalesPerson nvarchar(256));
  INSERT INTO @TopSalesPersons
    SELECT TOP (@persons) c.SalesPerson FROM SalesLT.Customer AS c
    JOIN SalesLT.SalesOrderHeader AS soh ON c.CustomerID=soh.CustomerID
    GROUP BY c.SalesPerson ORDER BY SUM(soh.SubTotal) DESC;
  INSERT INTO @Regions
    SELECT DISTINCT a.StateProvince, a.CountryRegion FROM SalesLT.Address AS a
    JOIN SalesLT.CustomerAddress AS ca ON a.AddressID=ca.AddressID
    JOIN SalesLT.Customer AS c ON ca.CustomerID=c.CustomerID
    JOIN @TopSalesPersons AS t3sp ON c.SalesPerson=t3sp.SalesPerson;
  RETURN;
END;
