IF OBJECT_ID('SalesLT.getLowestPrice', 'P') IS NOT NULL
  DROP PROC SalesLT.getLowestPrice;
GO
CREATE PROC SalesLT.getLowestPrice
  @category nvarchar(50),
  @lowestPrice money OUTPUT
AS
SET @lowestPrice = (
  SELECT MIN(p.ListPrice) FROM SalesLT.Product AS p
  JOIN SalesLT.ProductCategory AS pc ON p.ProductCategoryID = pc.ProductCategoryID
  WHERE pc.Name=@category);
RETURN ISNULL(@lowestPrice,0) / ISNULL(@lowestPrice,1);
GO
