<?php
namespace net\xmp\phpbook;
require './DatabaseConnection.php';
require './HTMLPage.php';

$html = new HTMLPage('AdventureWorks : Ładowanie zdjęcia produktu');
$form = <<<'EOF'
<form action="" enctype="multipart/form-data" method="post">
ID produktu: <input name="productID" /><br />
Plik: <input type="file" name="productPhoto" /><br />
<input type="submit" value="Wyślij" />
</form><br />
EOF;
$html->addHTML($form);

if (isset($_POST['productID'])) {
    // Połączenie z bazą danych
    $db = new DatabaseConnection();
    $db->connect();
    // Przygotowanie zapytania
    $query = 'UPDATE  SalesLT.Product
              SET ThumbNailPhoto  = ?,  ThumbnailPhotoFileName  = ?
              WHERE  ProductID  = ?';
    $id = (int) $_POST['productID'];
    $filename = filter_var($_FILES['productPhoto']['name'],
                           FILTER_SANITIZE_STRING, FILTER_FLAG_STRIP_LOW);
    // Otwarcie pliku
    $file = fopen($_FILES['productPhoto']['tmp_name'], 'rb');
    // Ustawienie kodowania i typu danych
    $params = array(array($file, null, SQLSRV_PHPTYPE_STREAM(SQLSRV_ENC_BINARY),
                                       SQLSRV_SQLTYPE_VARBINARY('MAX')),
                    $filename, $id);
    $stmt = sqlsrv_query($db->handle, $query, $params);
    // Zamknięcie pliku
    fclose($file);
    if ($stmt === false) {
        $db->exitWithError('Ładowanie zdjęcia nie powiodło się.');
    }
    if (sqlsrv_rows_affected($stmt) != 1) {
        $db->exitWithError('Czyżbyś podał błędny identyfikator?');
    }
    $html->addElement('p', 'Zdjęcie zostało załadowane.');
    // Zamknięcie połączenia z bazą danych
    sqlsrv_free_stmt($stmt);
    $db->close();
}
$html->printPage();
?>
