﻿<!DOCTYPE html>
<html>
<head>
    <title>Adventure Works : Produkty</title>
    <style type="text/css">
        th { font-size: 110%; border-bottom: 2px solid black; }
        td { padding: 3px; border-bottom: 1px solid #aaa }
    </style>
</head>
<body>
<h1>Adventure Works : Produkty</h1>
<table>
<?php
require './utils.php';
// połączenie z uwierzytelnieniem systemu Windows
$server = '(local)';
$connectionInfo = array('Database' => 'AdventureWorksLT2008', 'CharacterSet' => 'UTF-8');
$db = sqlsrv_connect($server, $connectionInfo);
if ($db === false) {
    exitWithSQLError('Nie udało się nawiązać połączenia z bazą danych.');
}
// odczytanie nazwy, ceny detalicznej i kategorii produktów
$query = "SELECT p.ProductID, p.Name AS ProductName, p.ListPrice, pc.Name AS CategoryName
          FROM SalesLT.Product AS p
          JOIN SalesLT.ProductCategory AS pc ON p.ProductCategoryID = pc.ProductCategoryID
          ORDER BY p.Name";
// wykonanie zapytania
$qresult = sqlsrv_query($db, $query);
if ($qresult === false) {
    exitWithSQLError('Zapytanie o dane produktów nie powiodło się.');
}
echo '<tr><th>ID</th><th>Produkt</th><th>Kategoria</th><th>Cena detaliczna</th></tr>';
// odczytanie kolejnych wierszy ze zbioru wyników
while ($row = sqlsrv_fetch_array($qresult)) {
    echo '<tr><td>', htmlspecialchars($row['ProductID']),
         '</td><td>', htmlspecialchars($row['ProductName']),
         '</td><td>', htmlspecialchars($row['CategoryName']),
         '</td><td>', htmlspecialchars($row['ListPrice']),
         "</td></tr>\n";
}
// null == brak dalszych wierszy, false == błąd
if ($row === false) {
    exitWithSQLError('Odczytanie danych o produktach nie powiodło się.');
}
// zwolnienie zasobów i zamknięcie połączenia 
sqlsrv_free_stmt($qresult);
sqlsrv_close($db);
?>
</table>
</body>
</html>