<?php
namespace net\xmp\phpbook; 
 
require './ExchangeSoapClient.php'; 
require './HTMLPage.php'; 
 
$options = array('login' => 'julia', 'password' => 'confidential', 
                 'CACert' => './my-ca.cer'); 
$client = new ExchangeSoapClient('./Services.wsdl', $options); 
$header = array('Version' => 'Exchange2010_SP1'); 
$reqver = new \SoapHeader(ExchangeSoapClient::TYPES_NS,  
                          'RequestServerVersion', $header); 
$client->__setSoapHeaders($reqver); 
 
$id = filter_input(INPUT_GET, 'id', FILTER_SANITIZE_STRING, FILTER_FLAG_STRIP_LOW); 
$key = filter_input(INPUT_GET, 'changekey', FILTER_SANITIZE_STRING,  
                                            FILTER_FLAG_STRIP_LOW); 
$param = array('ItemShape' => array('BaseShape' => 'Default', 
                                    'BodyType' => 'HTML', 
                                    'FilterHtmlContent' => true), 
               'ItemIds' => array('ItemId' => array('Id' => $id, 'ChangeKey' => $key))
); 
$response = $client->GetItem($param); 
$msg = $response->ResponseMessages->GetItemResponseMessage->Items->Message; 
 
$page = new HTMLPage('Wiadomo'); 
$table = array(array('Pole', 'Zawarto')); 
$table[] = addMailboxField('Od', $msg->From->Mailbox); 
$table[] = addMailboxField('do', $msg->ToRecipients->Mailbox); 
$table[] = addStringField('Temat', $msg->Subject); 
$table[] = addStringField('Wysane', $msg->DateTimeSent); 
$table[] = addStringField('Rozmiar', $msg->Size); 
$table[] = addBooleanField('Zaczniki', $msg->HasAttachments); 
$table[] = addBooleanField('Wymaga potwierdzenia odczytu', $msg->IsReadReceiptRequested); 
$table[] = array('Tekst', $msg->Body->_); 
$page->addTable($table, array(false, true)); 
$page->printPage(); 
 
function addStringField($name, $value) { 
    return array($name, htmlspecialchars($value)); 
} 
 
function addBooleanField($name, $value) { 
    return array($name, $value ? 'tak' : 'nie'); 
} 
 
function addMailboxField($name, $value) { 
    $value = htmlspecialchars($value->Name . ' <' . $value->EmailAddress . '>'); 
    return array($name, $value); 
}
?>
