<?php
namespace net\xmp\phpbook;

/**
* Pobieranie danych Autodiscover
* @param string $host Nazwa hosta serwera Exchange
* @param string $email Adres e-mail uytkownika
* @param string $login Nazwa uytkownika
* @param string $password Haso
* @param string $CAcert cieka do certyfikatu CA
*/
function autodiscover($host, $email, $login, $password, $CAcert) {
    $email = htmlspecialchars($email);
    $request = <<<EOF
<Autodiscover xmlns="http://schemas.microsoft.com/exchange/autodiscover/outlook/requestschema/2006">
  <Request>
    <EMailAddress>$email</EMailAddress>
    <AcceptableResponseSchema>http://schemas.microsoft.com/exchange/autodiscover/outlook/responseschema/2006a</AcceptableResponseSchema>
  </Request>
</Autodiscover>
EOF;
    $ch = curl_init("https://$host/Autodiscover/Autodiscover.xml");
    curl_setopt_array($ch, array(
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_POST => true,
        CURLOPT_USERAGENT => 'PHP-cURL/NTLM',
        CURLOPT_HTTPAUTH => CURLAUTH_NTLM,
        CURLOPT_USERPWD => "$login:$password",
        CURLOPT_SSL_VERIFYPEER => true,
        CURLOPT_SSL_VERIFYHOST => 2,
        CURLOPT_CAINFO => $CAcert,
        CURLOPT_HTTPHEADER => array('Content-Type: text/xml; charset=utf-8'),
        CURLOPT_POSTFIELDS => $request,
        CURLOPT_RETURNTRANSFER => true
    ));
    $response = curl_exec($ch);
    curl_close($ch);
    return $response;
}
?>
