WITH ProductDetail (SalesOrderID, TotalDue, Name,
                    LineTotal, PercentOfSubTotal, OrderQty) AS (
    SELECT soh.SalesOrderID, soh.TotalDue, p.Name, sod.LineTotal,
           sod.LineTotal/soh.SubTotal*100, sod.OrderQty
    FROM SalesLT.SalesOrderHeader AS soh
    JOIN SalesLT.SalesOrderDetail AS sod ON sod.SalesOrderID = soh.SalesOrderID
    JOIN SalesLT.Product AS p ON p.ProductID = sod.ProductID
)
SELECT SalesOrderID, TotalDue, Name, LineTotal, PercentOfSubTotal,
FROM ProductDetail AS pd
WHERE pd.OrderQty =
     ( SELECT max(pd2.OrderQty)
       FROM ProductDetail AS pd2
       WHERE pd2.SalesOrderID = pd.SalesOrderID
     );
GO
