// Pobieranie SID oraz primaryGroupID obiektu ($entryDN)
$result = ldap_read($ldapLink, $entryDN, 
                    '(objectSid=*)', array('objectSid','primaryGroupID')); 
$entry = ldap_first_entry($ldapLink, $result); 
$attr = ldap_get_attributes($ldapLink, $entry); 
$sid = sid2str($attr['objectSid'][0]); 
$pgid = $attr['primaryGroupID'][0]; 
// Odczyt SID grupy
$grSidStr = preg_replace('/\d+$/', $pgid, $sid); 
// Przygotowanie filtra wyszukiwania w LDAP
$grSid = str2sid($grSidStr); 
$searchsid = preg_replace('/(..)/', '\\\\$1', bin2hex($grSid)); 
// Wyszukiwanie grupy
$result = ldap_search($ldapLink, $baseDN, "(objectSid=$searchsid)", $attributeList);
