/**
 * KOnwertuje binarny GUID na cig znakw 
 * @param string $guid binarny GUID 
 */ 
function guid2str($guid) { 
    $last = substr(bin2hex($guid), 20); 
    $x = unpack('Vhead/v2mid/nmid3', $guid); 
    return sprintf("%08x-%04x-%04x-%04x-%s", $x['head'], $x['mid1'], 
                                             $x['mid2'], $x['mid3'], $last); 
} 
 
/** 
 * Konwertuje cig znakw na binarny GUID 
 * @param string $guidstr GUID jako cig znakw 
 */ 
function str2guid($guidstr) { 
    $v = explode('-', $guidstr); 
    return pack('VvvnH*', hexdec($v[0]), hexdec($v[1]), hexdec($v[2]), 
                          hexdec($v[3]), $v[4]); 
}
