<?php
namespace net\xmp\phpbook; 
 
class DatabaseConnection { 
 
    public $handle = null; 
    protected $serverName = '(local)'; 
    protected $connectionInfo = array( 
        'Database' => 'AdventureWorksLT2008', 
        'CharacterSet' => 'UTF-8' 
    ); 
 
    /** 
     * Tworzy poczenie z SQL. 
     * Korzysta z predefiniowanych parametrw poczenia. 
     */ 
    function connect() { 
        $this->handle = sqlsrv_connect($this->serverName, $this->connectionInfo); 
        if ($this->handle === false) { 
            $this->exitWithError('nieudane poczenie z baz danych'); 
        } 
    } 
 
    /** 
     * Rozcza poczenie z SQL Server. 
     */ 
    function close() { 
        if ($this->handle) { 
            sqlsrv_close($this->handle); 
            $this->handle = null; 
        } 
    } 
 
    /** 
     * Zamyka program i zwraca komunikat bdu z SQL Server.
     * 
     * @param string $txt Opis bdu 
     */ 
    function exitWithError($txt) { 
        $errors = sqlsrv_errors(); 
        $html = new HTMLPage('Bd bazy danych'); 
        $html->addElement('p', $txt); 
        $table = array(array('Status SQL', 'Kod', 'Komunikat'));
        foreach ($errors as $error) { 
            // Komunikaty bdu maj format ISO-8859-1
            $msg = iconv('ISO-8859-1', 'UTF-8', $error['message']); 
            $table[] = array($error['SQLSTATE'], $error['code'], $msg); 
        }
        $html->addTable($table); 
        $html->printPage(); 
        $this->close(); 
        exit; 
    } 
} 
?>
