﻿<?php
/**
 * Zakończenie programu i zwrócenie komunikatu błędu SQL Servera
 * @param string $txt Opis kontekstu błędu
 */
function exitWithSQLError($txt) {
    $errors = sqlsrv_errors();
    echo '<h1>Błąd bazy danych</h1>';
    echo "<p>Błąd:  $txt</p>";
    foreach ($errors as $error) {
        echo '<p><b>Status SQL:</b> ', htmlspecialchars($error['SQLSTATE']), '<br />',
             '<b>Kod:</b> ', htmlspecialchars($error['code']), '<br />',
             '<b>Komunikat</b>: ',
             // Komunikaty błędów są przekazywane w formacie ISO-8859-1
             htmlspecialchars(iconv('ISO-8859-1', 'UTF-8', $error['message'])),
             '</p>';
    }
    echo '<p>Wykonanie programu zakończyło się błędami.</p>';
    exit;
}
?>