<?php
namespace net\xmp\phpbook;

require './ExchangeSoapClient.php';
require './HTMLPage.php';
require './Mailbox.php';

$page = new HTMLPage('Tworzenie spotkania');
try {
    $param = getMeetingParameters();
    $options = array('login' => 'tomasz.chomik', 'password' => 'confidential',
                     'CACert' => './my-ca.cer');
    $client = new ExchangeSoapClient('./Services.wsdl', $options);
    $client->CreateItem($param);
    $page->addElement('p', 'Spotkanie zostao utworzone.');
} catch (\Exception $e) {
    $page->addElement('h2', 'Bd (Exception)');
    $page->addElement('p', $e);
}
$page->printPage();

function getMeetingParameters() {
    $param = array('SendMeetingInvitations' => 'SendOnlyToAll',
        'Items' => array('CalendarItem' => array(
            'Subject' => getValue('subject'),
            'Start' => getValue('start') . 'T' . getValue('startT') . ':00',
            'End' => getValue('end') . 'T' . getValue('endT') . ':00',
            'Location' => getValue('location'),
            'RequiredAttendees' => getAttendees('required'),
            'OptionalAttendees' => getAttendees('optional'),
            'Resources' => getAttendees('resource'))));
    return $param;
}

function getValue($name) {
    if (!isset($_POST[$name])) {
        throw new \Exception('Pole "$name" nie zostao podane.');
    }
    return filter_input(INPUT_POST, $name, FILTER_UNSAFE_RAW, FILTER_FLAG_STRIP_LOW);
}

function getAttendees($name) {
    if (!isset($_POST[$name]) || !is_array($_POST[$name])) {
        throw new \Exception('Pole "$name" nie zostao podane.');
    }
    $attendee = array();
    foreach ($_POST[$name] as $mail) {
        $email = trim(filter_var($mail, FILTER_SANITIZE_EMAIL));
        if (!empty($email)) {
            $attendee[] = array('Mailbox' => new Mailbox($email));
        }
    }
    if (!count($attendee)) {
        return null;
    }
    return array('Attendee' => $attendee);
}
?>
