<?php
namespace net\xmp\phpbook;

class ExchangeSoapClient extends \SoapClient {
    
    const TYPES_NS = "http://schemas.microsoft.com/exchange/services/2006/types";
    const MESSAGES_NS = "http://schemas.microsoft.com/exchange/services/2006/messages";

    protected $options;
    protected $curl_handle;
    public $curl_info;

    function __construct($wsdl, $options=array()) {
        $this->options = $options;
        parent::__construct($wsdl, $options);
    }

    function __doRequest($request, $location, $action, $version, $one_way=0) {
        if (empty($this->curl_handle)) {
            $this->curl_handle = curl_init();
            curl_setopt_array($this->curl_handle, array(
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_POST => true,
                CURLOPT_USERAGENT => 'PHP-cURL/NTLM-SOAP',
                CURLOPT_HTTPAUTH => CURLAUTH_NTLM,
                CURLOPT_USERPWD => $this->options['login'] . ':' . $this->options['password'],
                CURLOPT_SSL_VERIFYPEER => true,
                CURLOPT_SSL_VERIFYHOST => 2,
                CURLOPT_CAINFO => $this->options['CACert'],
                CURLOPT_RETURNTRANSFER => true,
                CURLINFO_HEADER_OUT => true,
                CURLOPT_HEADER => true));
        }
        curl_setopt_array($this->curl_handle, array(
            CURLOPT_HTTPHEADER => array("SOAPAction: \"$action\"",
                                        'Content-Type: text/xml; charset=utf-8'),
            CURLOPT_POSTFIELDS => $request,
            CURLOPT_URL => $location));
        $response = curl_exec($this->curl_handle);
        $this->curl_info = curl_getinfo($this->curl_handle);
        if ($response !== false) {
            $xml = strpos($response, '<?xml ');
            if ($xml) {
                $this->curl_info['response_header'] = substr($response, 0, $xml);
                $response = substr($response, $xml);
            } else {
                $this->curl_info['response_header'] = $response;
                $response = false;
            }
        }
        return $response;
    }

    function __getLastRequestHeaders() {
        return $this->curl_info['request_header'];
    }

    function __getLastResponseHeaders() {
        return $this->curl_info['response_header'];
    }
}
?>
