﻿<?php
//namespace net\xmp\phpbook;

class UpdateOrders
{
    protected $db;
    protected $stmt;
    // zmienne powiązane z poleceniem
    protected $sql_qty, $sql_discount, $sql_id;

    /**
     * Konstruktor ustawia połączenie z bazą danych
     */
    function __construct($db) {
        $this->db = $db;
    }

    /**
     * Wczytanie odpowiednich danych z tabeli i zapisanie ich w tablicy HTML.
     * @param int $id Wielkość zamówienia
     */
    function getByHeader($id) {
        $query = 'SELECT SalesOrderDetailID, OrderQty, UnitPriceDiscount
                  FROM SalesLT.SalesOrderDetail WHERE SalesOrderID = ?';
        $params = array($id);
        $stmt = sqlsrv_query($this->db->handle, $query, $params);
        if ($stmt === false) {
            $this->db->exitWithError('Wykonanie zapytania nie powiodło się.');
        }
        // wczytanie pojedynczych wierszy z danymi wynikowymi
        $table = array(array('ID', 'Ilość', 'Zniżka'));
        while ($row = sqlsrv_fetch_array($stmt)) {
            $table[] = array($row['SalesOrderDetailID'], $row['OrderQty'],
                             $row['UnitPriceDiscount']);
        }
        if ($row === false) {
            $this->db->exitWithError('Pobieranie danych nie powiodło się.');
        }
        sqlsrv_free_stmt($stmt);
        return $table;
    }

    /**
     * Przygotowanie polecenia UPDATE.
     */
    function prepare() {
        $query = 'UPDATE SalesLT.SalesOrderDetail
                  SET OrderQty = ?, UnitPriceDiscount = ?
                  WHERE  SalesOrderDetailID  = ?';
        // Parametry muszą być przekazywane przez odwołania (&$...).
        // Dzięki temu wszelkie późniejsze zmiany wartości zmiennych
        // zostaną uwzględnione w predefiniowanym poleceniu T-SQL.
        $params = array(&$this->sql_qty, &$this->sql_discount, &$this->sql_id);
        // Przygotowanie polecenia
        $this->stmt = sqlsrv_prepare($this->db->handle, $query, $params);
        if ($this->stmt === false) {
            $this->db->exitWithError("Przygotowanie polecenia nie powiodło się.");
        }
    }

    /**
     * Wykonanie predefiniowanego polecenia.
     * Nowe wartości są przekazywane jako parametry.
     */
    function update($id, $qty, $discount) {
        // Zmiana wartości zmiennych jest odzwierciedlona w poleceniu T-SQL,
        // ponieważ zmienne zostały dowiązane przez odwołania.
        $this->sql_id = $id;
        $this->sql_qty = $qty;
        $this->sql_discount = $discount;
        if (sqlsrv_execute($this->stmt) === false) {
            $this->db->exitWithError('Zmiana wartości nie powiodła się.');
        }
    }

    function free() {
        sqlsrv_free_stmt($this->stmt);
    }
}
?>
