<?php
namespace net\xmp\phpbook; 
require './ExchangeSoapClient.php'; 
require './HTMLPage.php'; 
$options = array('login' => 'dorota', 'password' => 'confidential',
                 'CACert' => './my-ca.cer', 
                 'features' => SOAP_SINGLE_ELEMENT_ARRAYS); 
$client = new ExchangeSoapClient('./Services.wsdl', $options); 
 
// Wyszukiwanie spotka w wybranym okresie czasu 
$param = array('Traversal' => 'Shallow', 
    'ItemShape' => array('BaseShape' => 'Default',), 
    'CalendarView' => array( 
        'StartDate' => '2011-09-12T00:00:00', 
        'EndDate' => '2011-09-16T23:59:59'), 
    'ParentFolderIds' => array( 
        'DistinguishedFolderId' => array('Id' => 'calendar'))); 
$response = $client->FindItem($param); 
 
$page = new HTMLPage('Przeszukiwanie kalendarza'); 
$items = $response->ResponseMessages->FindItemResponseMessage[0] 
                  ->RootFolder->Items->CalendarItem; 
showMeetings('Spotkania w wybranym okresie czasu', $items, $page); 
 
// Wybranie spotkania I pokazanie jego spotka ssiadujcych orazkonfliktw 
$item = $items[2]; 
$param = array('ItemShape' => array( 
                  'BaseShape' => 'Default', 
                  'AdditionalProperties' => array( 
                     'FieldURI' => array( 
                        array('FieldURI' => 'calendar:ConflictingMeetingCount'), 
                        array('FieldURI' => 'calendar:AdjacentMeetingCount'), 
                        array('FieldURI' => 'calendar:ConflictingMeetings'), 
                        array('FieldURI' => 'calendar:AdjacentMeetings')))), 
               'ItemIds' => array( 
                  'ItemId' => array('Id' => $item->ItemId->Id, 
                                    'ChangeKey' => $item->ItemId->ChangeKey))); 
$response = $client->GetItem($param); 
 
$item = $response->ResponseMessages->GetItemResponseMessage[0] 
                 ->Items->CalendarItem[0]; 
if ($item->ConflictingMeetingCount) { 
    showMeetings('Terminy kolidujce', 
                 $item->ConflictingMeetings->CalendarItem, $page, false); 
} 
if ($item->AdjacentMeetingCount) { 
    showMeetings('Ssiednie spotkania', 
                 $item->AdjacentMeetings->CalendarItem, $page, false); 
} 
$page->printPage(); 
 
function showMeetings($name, $items, $page, $showType=true) {
    $page->addElement('h2', $name);
    $table = array(array('Temat', 'Rozpoczcie', 'Zakoczenie', 'Status')); 
    if ($showType) { 
        $table[0][] = 'Type'; 
    } 
    foreach ($items as $item) { 
        $data = array($item->Subject, $item->Start, $item->End, 
                      $item->LegacyFreeBusyStatus); 
        if ($showType) {
            $data[] = $item->CalendarItemType; 
        } 
        $table[] = $data; 
    } 
    $page->addTable($table); 
} 
?>
