<?php
namespace net\xmp\phpbook; 
 
class SearchParameters { 
     
    protected $values; 
    protected $restrictions; 
    protected $mode; 
    protected $comparison; 
     
    function __construct($values) { 
        $this->values = $values; 
    } 
    function getParams() {
        $this->restrictions = array(); 
        $this->mode = $this->getWhiteListValue('mode', array('exact' => 'FullString', 
                                              'prefix' => 'Prefixed', 
                                              'substr' => 'Substring'), 'substr'); 
        $this->comparison = empty($this->values['case']) ? 'IgnoreCase' : 'Exact'; 
        $this->addHomeAddressContains('City'); 
        $this->addHomeAddressContains('PostalCode'); 
        $this->addHomeAddressContains('CountryOrRegion'); 
        $this->addCreatedAfter(); 
        $this->addNoField(); 
        $param = array('Traversal' => 'Shallow', 
            'ItemShape' => array('BaseShape' => 'Default'), 
            'ParentFolderIds' => array('DistinguishedFolderId' => array( 
                                       'Id' => 'contacts'))); 
        if (!empty($this->restrictions)) { 
            $param['Restriction'] = array('And' => $this->restrictions); 
        } 
        return $param; 
    } 
 
    protected function addHomeAddressContains($field) { 
        $value = $this->getValue($field); 
        if (empty($value)) { 
            return; 
        } 
        $contains =  array('ContainmentMode' => $this->mode, 
                           'ContainmentComparison' => $this->comparison, 
                           'IndexedFieldURI' => array( 
                              'FieldURI' => "contacts:Physical Address:$field", 
                              'FieldIndex' => "Home"), 
                           'Constant' => array('Value' => $value)); 
        if (!isset($this->restrictions['Contains'])) { 
            $this->restrictions['Contains'] = array($contains); 
        } 
        else { 
            $this->restrictions['Contains'][] = $contains; 
        } 
    } 
 
    protected function addCreatedAfter() { 
        $date = $this->getValue('created'); 
        if (!empty($date)) { 
            $timestamp = $date . 'T00:00:00Z'; 
            $this->restrictions['IsGreaterThan'] = array( 
                'FieldURI' => array('FieldURI' => "item:DateTimeCreated"), 
                'FieldURIOrConstant' => array('Constant' => array( 
                                              'Value' => $timestamp)));
        } 
    } 
    protected function addNoField() {
        $noField = $this->getWhiteListValue('field', array('-' => false, 
                                            'manager' => 'contacts:Manager', 
                                            'assistant' => 'contacts:AssistantName', 
                                            'jobtitle' => 'contacts:JobTitle'), '-'); 
        if ($noField !== false) { 
            $this->restrictions['Not'] = array('Exists' => array('FieldURI' => array( 
                                               'FieldURI' => $noField))); 
        } 
    } 
     
    function getValue($name) { 
        if (!isset($this->values[$name])) { 
            return false; 
        } 
        return trim(filter_var($this->values[$name], FILTER_UNSAFE_RAW,  
                                                     FILTER_FLAG_STRIP_LOW)); 
    } 
 
    function getWhiteListValue($name, $list, $default) { 
        $value = $this->getValue($name); 
        return isset($list[$value]) ? $list[$value] : $list[$default]; 
    } 
}
?>
