<?php
namespace net\xmp\phpbook; 
 
function modify($ad) { 
    $dn = 'OU=test,OU=Chomik,OU=Test-OU,DC=xmp,DC=site'; 
    $success = ldap_delete_recursive($ad, $dn); 
    if (!$success) { 
        $ad->exitWithError("Nie mona usun OU"); 
    } 
    // Brak wynikw
    $before = array('dn' => "Rekurencyjne usuwanie: $dn", 'count' => 0); 
    $after = array('count' => 0); 
    return array($before, $after); 
} 
 
function ldap_delete_recursive($ad, $dn) { 
    $result = ldap_list($ad->handle, $dn, '(objectClass=*)', array('name')); 
    if (!$result) { 
        return false; 
    } 
    $entries = ldap_get_entries($ad->handle, $result); 
    ldap_free_result($result); 
    if (!$entries) { 
        return false; 
    } 
    for ($i = 0; $i < $entries['count']; $i++) { 
        $result = ldap_delete_recursive($ad, $entries[$i]['dn']); 
        if (!$result) { 
            return false; 
        } 
    } 
    return ldap_delete($ad->handle, $dn); 
} 
?>
