/**
 * konwertuje znacznik czasu Windows na cig znakw 
 * @param string $stamp znacznik czasu Windows
 */ 
function winStamp2str($stamp) { 
    if (!$stamp) { 
        return 'nieznany'; 
    } elseif ($stamp == '9223372036854775807') { 
        return 'nigdy'; 
    } 
    $stamp = substr($stamp, 0, -7);         // 100ns -> s 
    $stamp = bcsub($stamp, '11644473600');  // 1601 -> 1970 
    return date('Y-m-d H:i:s O', $stamp); 
} 
 
/** 
 * Konwertuje czas Unix (time()) na znacznik czasu Windows
 * @param int $stamp czas Unix (sekundy od 1970) 
 */ 
function time2winStamp($stamp) { 
    if (!$stamp) { 
        return '0'; 
    } elseif ($stamp == 0xffffffff) { 
        return '9223372036854775807'; 
    } 
    $stamp = bcadd($stamp, '11644473600');  // 1970 -> 1601 
    return $stamp . '0000000';              // s -> 100ns 
}
