﻿<?php
//namespace net\xmp\phpbook;

/**
 * Zapytanie o wszystkie produkty, których nazwy rozpoczynają się od $name.
 * @return array Dane do tabeli HTML
 */
function getProductsByName($name) {
    $db = new DatabaseConnection();
    $db->connect();
    // odczytanie nazwy i ceny detalicznej produktów
    $query = 'SELECT ProductID, Name, ListPrice
              FROM SalesLT.Product WHERE Name LIKE ?
              ORDER BY Name';
    $params = array($name . '%');
    // wykonanie zapytania
    $stmt = sqlsrv_query($db->handle, $query, $params);
    if ($stmt === false) {
        $db->exitWithError('Odczytanie danych produktów nie powiodło się.');
    }
    if (!sqlsrv_has_rows($stmt)) {
        return false; // brak wyników w bazie (zbiór wyników jest pusty)
    }
    // pobranie kolejnych wierszy ze zbioru wyników
    $table = array(array('ID', 'Produkt', 'Cena detaliczna'));
    while ($row = sqlsrv_fetch_array($stmt)) {
        $table[] = array($row['ProductID'], $row['Name'],
            $row['ListPrice']);
    }
    // null == brak dalszych wierszy, false == błąd
    if ($row === false) {
        $db->exitWithError('Pobranie danych produktu nie powiodło się.');
    }
    sqlsrv_free_stmt($stmt);
    $db->close();
    return $table;
}
?>
