<?php
namespace net\xmp\phpbook;

// Klasa wyjtku
class LDAPException extends Exception { } 
 
/** 
 * Uwierzytelnianie uytkownika w Active Directory 
 * @param string $server Nazwa serwera 
 * @param string $username Nazwa uytkownika
 * @param string $password Haso
 * @param boolean $secure Okrela, czy poczenie jest szyfrowane
 * @return boolean True jeeli uwierzytelnienie udane, false jeeli nieudane 
 * @throws LDAPConnectionException 
 */ 
function authenticate($server, $username, $password, $secure=true) { 
    $handle = ldap_connect($server); 
    if ($secure) { 
        if (!ldap_start_tls($handle)) { 
            throw new LDAPException('Bd poczenia LDAP'); 
        } 
    } 
    if (!ldap_bind($handle, $username, $password)) { 
        $code = ldap_errno($handle); 
        ldap_unbind($handle); 
        if ($code != 49) { 
            throw new LDAPException('Bd poczenia LDAP'); 
        } 
        return false; 
    } 
    ldap_unbind($handle); 
    return true; 
}

