<?php
namespace net\xmp\phpbook;
require_once './HTMLPage.php';

class LDAPConnection {

    public $handle = null;

    function connect($server, $userName, $password, $secure=false) {
        $this->handle = ldap_connect($server);
        ldap_set_option($this->handle, LDAP_OPT_PROTOCOL_VERSION, 3);
        ldap_set_option($this->handle, LDAP_OPT_REFERRALS, 0);
        if ($secure) {
            if (!ldap_start_tls($this->handle)) {
                $this->exitWithError('TLS start failed');
            }
        }
        if (!ldap_bind($this->handle, $userName, $password)) {
            $this->exitWithError('Binding of LDAP connection failed');
        }
    }

    function close() {
        if ($this->handle) {
            ldap_unbind($this->handle);
            $this->handle = null;
        }
    }

    function exitWithError($txt) {
        $html = new HTMLPage('LDAP error');
        $html->addElement('p', $txt);
        $table = array(array('Number', 'Message'),
                       array(ldap_errno($this->handle), ldap_error($this->handle)));
        $html->addTable($table);
        $html->printPage();
        $this->close();
        exit;
    }
}
?>
