
var anim_class = {
    SVG: null,
    objectsAr: {},
    objectsID: 0,
    FPSlimit: 30,
    /* Funkcje zwrotne okreslajace wartosc animowanego parametry w czasie */
    animModeCallback: function(t, mode) {
        var obj = {
            "=": function() {return t},
            "<": function() {return Math.pow(t, 3)},
            ">": function() {return Math.pow(t-1, 3)+1},
            "<><": function() {
                    t *= 2;
                    if(t < 1) {
                        return Math.pow(t, 3);
                        }
                    t--;
                    var om = 15,
                        d = 0.3;
                    return 1 + (Math.sin(om*t)) * (d * (1-t));
                    },
            "<>|": function() {
                    t *= 2;
                    if(t < 1) {
                        return Math.pow(t, 3);
                        }
                    t--;
                    var om = 5,
                        d = 0.3;
                    t = 1 - Math.abs((Math.sin(om*t)) * (d * (1-t)));
                    return t;
                    },
            "<>": function() {
                    t *= 2;
                    if (t < 1) {
                        return Math.pow(t, 3) / 2;
                    }
                    t -= 2;
                    return (Math.pow(t, 3) + 2) / 2;
                    },
            "backIn": function() {
                    var s = 1.70158;
                    return t * t * ((s + 1) * t - s);
                    },
            "backOut": function() {
                    t = t - 1;
                    var s = 1.70158;
                    return t * t * ((s + 1) * t + s) + 1;
                    }
                };
        return (mode)? obj[mode]() : (obj["="])();
        },
    /* Kontynuacja animacji */
    _animContinue: {
        /* Continue transforms animation */
        transform: function(animObj, factor) {//Tylko translacja i rotacja wzgledna
            
            factor = anim_class.animModeCallback(factor, animObj.animMode);
            var _f = factor - animObj.lastFactor;
                //roundValue = function(v) {
                //    if(animObj.precision > -1 && !factor) {
                //        var actualValue = Math.round(v * factor * animObj.precisionFactor) / animObj.precisionFactor;
                //        if(actualValue != animObj.lastValue) {
                //            animObj.lastValue = actualValue;
                //            return true;
                //            }
                //        else
                //            return false;
                //        //console.log(actualValue);
                //        };                    
                //    };
            
            var newTr = anim_class.SVG.createSVGTransform(),
                o = animObj.obj.transform.baseVal.getItem(0),
                v = animObj.values,
                bb = animObj.obj.getBBox(),
                modifyTransform = {
                "scale": function() {
                    /* Code */
                    },
                'translate': function() {
                    var roundValue = function(v) {
                        animObj.totalValue += v;
                        var actualValue = Math.round(animObj.totalValue * animObj.precisionFactor) / animObj.precisionFactor;
                        if(actualValue != animObj.lastValue) {
                            animObj.lastValue = actualValue;       
                            return v;
                            }
                        else{
                            return false;
                            };
                                                
                        };
                        
                    if(animObj.precision > -1) { 
                        (function(v) {
                            if(v) o.matrix.e += v;  
                            })(roundValue(v[0] * _f));
                        (function(v) {
                            if(v) o.matrix.f += v;  
                            })(roundValue(v[1] * _f));
                        }
                    else{
                        o.matrix.e += v[0] * _f;              
                        o.matrix.f += v[1] * _f;                        
                        };
                    },
                'rotate': function() {
                    newTr.setRotate(v[0] * _f, (bb.x) + bb.width/2, bb.y + bb.height/2);
                    var m = o.matrix.multiply(newTr.matrix);
                    o.setMatrix(m);
                    }
                };
            animObj.lastFactor = factor;
            modifyTransform[animObj.transformName]();
            },
        /* Continue attributes animation */
        attribute: function(animObj, factor) {
            factor = anim_class.animModeCallback(factor, animObj.animMode);
            var v = animObj.values,
                actualValue = v[0] + factor * (v[1] - v[0]);
                
            if(animObj.precision > -1 && !factor) {
                actualValue = Math.round(actualValue * animObj.precisionFactor) / animObj.precisionFactor;
                if(actualValue != animObj.lastValue)
                    animObj.lastValue = actualValue;
                else
                    return;
                };
                                           
            if(animObj.attrType === 'style') {
                animObj.obj.style[animObj.attrName] = actualValue;
                return;
                };
            animObj.obj.setAttribute(animObj.attrName, actualValue);
            }
        },
    /* Funkcja zostaje wywolana gdy animacja zostaje zakonczona */
    _animEnd: function(animObj, i) {
            anim_class._animContinue[animObj.animType](animObj, 1);
            anim_class.executeCallbackEndAnimations.unregister(animObj.ID);
            (function(Fn) {
                delete anim_class.objectsAr[i];
                try{Fn()()} catch(er) {};
                })(animObj.Fn);
            },
    /* Glowna funkcja animacyjna */
    _anim: function() {
        var animObj, factor, frameLength = 1000 / (this.FPSlimit || 1000), actualTime,
            timeLastFrame = new Date().getTime(), actualTime,
            anm = function() {
                actualTime = new Date().getTime();          
                if(actualTime - timeLastFrame >= frameLength) {
                    timeLastFrame = actualTime;
                    for(var i in anim_class.objectsAr) {
                        animObj = anim_class.objectsAr[i];
                        if(animObj.status === 'pause') {
                            continue;
                            };
                        if(animObj.status === 'stop') {
                            delete anim_class.objectsAr[i];
                            continue;
                            };
                        factor = (new Date().getTime() - animObj.startTime)/animObj.totalTime;
                        if(factor >= 1) {
                            anim_class._animEnd(animObj, i);
                            }
                        else{
                            anim_class._animContinue[animObj.animType](animObj, factor);
                            };                        
                        };
                };
            setTimeout(anm, 5);
            };                      
        anm();
        },
    /* Sprawdzenie czy wlasciwosc, lub transformacja obiektu sa juz animowane */
    _check: function(animObj) {
        var ar = this.objectsAr;
        for(var i in ar) {
            if(ar[i].obj === animObj.obj) {
                if(ar[i].transformName && animObj.transformName === ar[i].transformName) {
                    return true;
                    };
                if(ar[i].attrName && animObj.attrName === ar[i].attrName) {
                    return true;
                    };
                };
            };
        return false;
        },
    /* Dodawanie obiektu do tablicy animowanych obiektow */
    add: function(animObj) {
        if(anim_class._check(animObj))
            return null;          
        return (function(i) {
            if(animObj.attrName) {
                animObj.animType = 'attribute';
                }
            else{
                animObj.animType = 'transform';
                animObj.transformName = animObj.transformName || "translate";
                anim_class._consolidateTransforms(animObj);
                anim_class._prepareValues(animObj);
                animObj.lastFactor = 0;
                };
            animObj.status = 'pause';
            animObj.ID = i;
            animObj.lastValue  = null;
            animObj.totalValue = 0;
            animObj.precision = (animObj.precision >= 0)? animObj.precision : -1;//Precyzja ustawianych wartosci (liczbe miejsc po przecinku). Wartosc -1 oznacza dowolna precyzje.
            animObj.precisionFactor = (animObj.precision >= 0)? Math.pow(10, animObj.precision) : null;
            anim_class.objectsAr[i] = animObj;
            return animObj;
            })(this.objectsID++);
        },
    translate: function(obj, tx, ty) {
        this._animContinue.transform({obj: obj, lastFactor: 0, transformName: "translate", values: [tx, ty||0]}, 1);
        },
    rotate: function(obj, angle) {

        },
    /* Tworzenie nowej transformacji wykorzystanej podczas animacji */
    _createNewTransform: function(animObj) {
        var obj = animObj.obj,
        create = function() {
            return obj.transform.baseVal.appendItem(anim_class.SVG.createSVGTransform());            
            };
        return create();
        },
    /* Konsolidacja transformacji - przeksztalcenie wielu transformacji w jedna macierz transformacji */
    _consolidateTransforms: function(animObj) {
        var len = animObj.obj.transform.baseVal.numberOfItems;
        if(!len) {
            anim_class._createNewTransform(animObj);
            return;
            };
        if(len === 1)
            return;
        (function(tr) { 
            tr.initialize(tr.consolidate());          
            })(animObj.obj.transform.baseVal);
        },
    /* Przeksztalcenie/sprawdzenie (o ile jest konieczne) wartosci animowanego atrybutu lub transformacji */
    _prepareValues: function(animObj) {
        var v = animObj.values;
        switch(animObj.transformName) {
            case 'translate': {
                if(v.length < 2)
                    v[1] = 0;
                break;
                }
            case 'rotate': {
                (function(d) {
                    //v[0] = ((((v[0]<0)? 360+v[0]:v[0]) - d) - ((v[0]<0)? 360:0))%360;
                    })(0);
                break;
                }
                };
        },
    /**
    *
    * Rejestracja/wyrejestrowanie animacji po ktorych
    * zakonczeniu ma byc wywolana funkcja zwrotna przekazana
    * jako argument. W dalszym ciagu osobna funkcja zwrotna
    * moze zostac ustalona kazdej animacji z osobna.
    * 
    */
    executeCallbackEndAnimations: {
        
    animObjIDAr    : {},
    registerAnimAr : [],
        
    unregister: function(animObjID) {
        var registerID = this.animObjIDAr[animObjID];
        if(registerID >= 0) {
            if(!--this.registerAnimAr[registerID][0]) {
                try{this.registerAnimAr[registerID][1]()}
                catch(err) {};
                delete this.registerAnimAr[registerID];
                };
            delete this.animObjIDAr[animObjID];
            };
        },
    register: function() {
            var newRegisterID = this.registerAnimAr.length;
            var len = arguments.length - 1, j = 0;
            for(var i=0; i<len; i++) {
                if(arguments[i] != null) {
                    this.animObjIDAr[arguments[i].ID] = newRegisterID;
                    j++;
                    };
                };
            this.registerAnimAr[newRegisterID] = [j, arguments[len]];
            }
    },
    registerEndAnimations: function() {
        this.executeCallbackEndAnimations.register.apply(this.executeCallbackEndAnimations, arguments);
        },
    /* Start animation */
    start: function(animObj) {          
        if(!animObj || animObj.status === 'start')
            return null;
        animObj.startTime = new Date();
        animObj.status = 'start';
        return animObj;
        },
    /* Wrappers */
    animAttr: function(obj, attrName, vStart, vStop, totalTime, FnCallback) {
        this.start(
            anim_class.add({
                obj: obj,
                attrName: attrName,
                values: [vStart, vStop],
                totalTime: totalTime || 500,
                Fn: FnCallback
                })       
            );        
        },
    animStyle: function(obj, propName, vStart, vStop, totalTime, FnCallback) {
        this.start(
            anim_class.add({
                obj: obj,
                attrType: "style",
                attrName: propName,
                values: [vStart, vStop],
                totalTime: totalTime || 500,
                Fn: FnCallback
                })       
            );
        },
    animTranslate: function(obj, tx, ty, totalTime, FnCallback) {
        this.start(
            anim_class.add({
                obj: obj,
                values: [tx, ty],
                totalTime: totalTime || 500,
                Fn: FnCallback
                })       
            );         
        },
    animRotate: function(obj, angle, totalTime, FnCallback) {
        this.start(
            anim_class.add({
                obj: obj,
                transformName: "rotate",
                values: [angle],
                totalTime: totalTime || 500,
                Fn: FnCallback
                })       
            );        
        },
    /* END */
    /* Zatrzymanie animacji i usuniecie z tablicy animowanych obiektow */
    stop: function(objID) {
        this.objectsAr[objID].status = 'stop';
        },
    /* Zainicjowanie klasy animacyjnej */
    init: function() {
        this.SVG = document.documentElement;
        this._anim();
        }
    };
anim_class.init();
