var smoothScroll = function(divCnt, divMask) {
    
    var scrollTime = 2000,
        factorCallbackFn = function(t) {
            return Math.pow(t-1, 3)+1;
            };
            
    this.stopTop = 0;
    this.lastStopTop = 0;
    this.actualTop = 0;
    this.startTop = 0;
    this.startTime = 0;
    this.active = false;
    this.divCntRef  = (typeof divCnt  === "string")? document.getElementById(divCnt)  : divCnt;
    this.divMaskRef = (typeof divMask === "string")? document.getElementById(divMask) : divMask;
    this.anchor = setInterval((function(_this_) {return function() {_this_.anim()}})(this), 20);
    this.updatePosition = function() {
        this.startTime = new Date().getTime();
        this.startTop = this.actualTop;
        this.difTop = this.stopTop - this.actualTop;
        this.lastStopTop = this.stopTop;            
        };     
    this.anim = function() {
        if(this.actualTop == this.stopTop) {
            return;
            };

        if(this.active) {    
            var factorTime = (new Date().getTime() - this.startTime)/scrollTime;
            
            if(factorTime > 1) {
                factorTime = 1;
                this.actualTop = this.lastStopTop;
                };
            
            this.actualTop = this.startTop + this.difTop * factorCallbackFn(factorTime);
            this.divCntRef.style.top = this.actualTop + "px";            
            };    
            
        if(this.lastStopTop != this.stopTop){        
            this.updatePosition();
            this.active = true;
            };
        };
    this.reset = function() {
        this.actualTop = this.stopTop = this.startTop = this.lastStopTop = 0;
        this.active = false;
        this.divCntRef.style.top = "0px";
        };
    this.scroll = function(factor) {
        var cntHeight  = this.divCntRef.clientHeight,
            maskHeight = this.divMaskRef.clientHeight;
        if(cntHeight < maskHeight)
            return;
        this.stopTop = -(this.divCntRef.clientHeight - this.divMaskRef.clientHeight) * factor;
        };
    };   