var SVGScript = {
    tc: null,/* Reference to config object in HTML document */
    init: function(config) {
        this.tc = config;
        //Tworzenie obiektow reprezentujacych kolejne pozycje menu
        for(var i=0; i<config.SVGmenuLayersRef.length; i++) {
            var obj = config.SVGmenuLayersRef[i] = this.id2ob(config.SVGmenuLayersRef[i]);
            this.menu.add(config.SVGmenuLayersRef[i], config.SVGmenuPosRef[i], config.SVGMenuPosRotationRef[i], i);
            };
        //Dodawanie zdarzenia do logo (pokazywanie strony glownej)
        obj = this.id2ob(config.SVGlogoRef);
        this.addEvent(obj, "click", function() {
            SVGScript.menu.show();
            });
        obj.style.cursor = "default";
        //Dodatkowe referencje do elementow strony
        config.SVGtxtBackgroundRef = this.id2ob(config.SVGtxtBackgroundRef);
        config.SVGtxtColumnOne = this.id2ob(config.SVGtxtColumnOne);
        config.SVGtxtColumnTwo = this.id2ob(config.SVGtxtColumnTwo);
        config.SVGsliderRef[0] = this.id2ob(config.SVGsliderRef[0]);
        config.SVGsliderRef[1] = this.id2ob(config.SVGsliderRef[1]);
        //Dodawanie zdarzen do drugorzednego menu
        for(var i=0; i<config.SVGsecondaryMenuPos.length; i++) {
            var obj = config.SVGsecondaryMenuPos[i] = this.id2ob(config.SVGsecondaryMenuPos[i]);
            obj.style.cursor = "default";
            config.SVGsecondaryMenuPpp[i] = this.id2ob(config.SVGsecondaryMenuPpp[i]);
            obj.addEventListener("click", (function(i) {return function() {
                window.parent.siteScript.showText(i);
                SVGScript.animSecondaryMenu.show(i);
                }})(i), false);
            };
        //Dodawania zdarzen do menu na stopce
        for(var i=0; i<config.SVGfootMenuPosRef.length; i++) {
            var obj = config.SVGfootMenuPosRef[i] = this.id2ob(config.SVGfootMenuPosRef[i]);
            obj.style.cursor = "hand";
            //this.addEvent(obj, "mouseover", function() {});
            //this.addEvent(obj, "mouseout",  function() {});
            this.addEvent(obj, "click",     (function(obj) {return function() {
                SVGScript.toolTip.show(obj, "NO IMPLEMENTED");
                SVGScript.animFootMenu(obj);
                }})(obj));
            };
        config.SVGfootMenuUnderRect = this.id2ob(config.SVGfootMenuUnderRect);
        //Tworzenie suwaka
        this.slider.init();
        //Tworzenie referencji do chmurki
        config.SVGtooltip = this.id2ob(config.SVGtooltip);
        },
    blockEvents: false,//Blokowanie/odblokowaie procedur zarejestrowanych zdarzeń
    addEvent: function(obj, evtType, Fn) {//Rejestrowanie zdarzen. Gdy pole SVGScript.blockEvents ma wartosc true, zarejestrowane precedury obslugi zdarzenia nie sa wykonywane
        obj.addEventListener(evtType, function() {
            if(SVGScript.blockEvents)
                return;
            Fn();
            }, false);
        },
    id2ob: function(v) {
        try{
            return (typeof v === 'string')? document.getElementById(v) : (!v)? null:v;
            }
        catch(er) {return null};
        },
    menu: {//Metody i pola zwiazane z menu (glownie z animacjami)
        active: true,//Pole o wartosc true gdy trwa jakakolwiek zarejestrowana animacja
        activePosLength : 0,//Liczba zarejestrowanych animacji
        noActiveFnCallback: null,//Funkcja zwrotna uruchomiona przez metode executeFnCallback
        noActiveFnCallbackQueue: null,//Oczekujaca funkcja zwrotna (gdy funkcja noActiveFnCallback jest rozna od null)
        posAr  : [],//Tablica z referencjami do obiektow reprezentujacych kazda pozycje menu
        addNoActiveFnCallback: function(Fn) {//Okreslenie funkcji zwrotnej uruchamianej gdy zakoncza się wszystkie zarejestrowane animacje 
            SVGScript.blockEvents = true;
            if(!this.noActiveFnCallback) {
                this.noActiveFnCallback = Fn;
                if(!this.activePosLength) this.executeFnCallback();
                }
            else{
                this.noActiveFnCallbackQueue = Fn;
                }
            },
        addAnim: function(animObj) {//Rejestrowanie animacji przekazej jako argument
            if(animObj) {//animObj moze byc rowne null gdy dany atrybut badz transformacja sa juz animowane
                this.activePosLength++;         
                animObj.Fn = (function(Fn) {//Gdy animacja jest rejestrowana nastepuje zmniejszenie wartosci pola activePosLength po zakonczeniu animacji
                    return function() {
                    SVGScript.menu.decreaseActivePos();
                    Fn();
                    }})(animObj.Fn);
                }
            },
        decreaseActivePos: function() {//Zmniejszenie licznika (wartosci pola activePosLength). Gdy wszystkie zarejestrowane animacje sie zakoncza nastepuje wywolanie funkcji zwrotnej noActiveFnCallback
            if(!--this.activePosLength) {
                this.executeFnCallback();
                }          
            },
        executeFnCallback: function() {//Wywolanie funkcji zwrotnej i ustawienie jej wartosci jako referencji do funkcji oczekujacej noActiveFnCallbackQueue
            try{this.noActiveFnCallback()} catch(err) {};
            this.noActiveFnCallback = this.noActiveFnCallbackQueue || null;
            this.noActiveFnCallbackQueue = null;
            if(!this.noActiveFnCallback)
                SVGScript.blockEvents = false;
            },
        add : function(layerID, centerID, rotationID,  pageID) {//Tworzenie obiektu reprezentujacego pozycje menu
            var posMenu = function() {
                var _this_ = this;
                this.active = false;
                this.layerRef    = SVGScript.id2ob(layerID);
                this.centerRef   = SVGScript.id2ob(centerID);
                this.rotationRef = SVGScript.id2ob(rotationID);
                this.rotate = function(angle, totalTime) {
                    SVGScript.menu.addAnim(anim_class.start(anim_class.add({
                        obj          : _this_.rotationRef,
                        transformName: "rotate",
                        animMode     : "<>|",
                        values       : [angle || SVGScript.tc.animRotationAngle],
                        totalTime    : totalTime || SVGScript.tc.animRotationTime
                        })));
                    };
                    
                SVGScript.addEvent(this.centerRef, "click",     function() {
                    SVGScript.menu.addNoActiveFnCallback(function() {
                        SVGScript.menu.hide(pageID);
                        })});
                SVGScript.addEvent(this.centerRef, "mouseover", function() {
                    _this_.rotate();
                    });
                };
            this.posAr.push(new posMenu);
            },
        show : function() {//Pokazanie menu i ukrycie warstwy z trescia strony
            
            if(!SVGScript.tc.pageActive)//Gdy strona jest nieaktywna (pokazane menu) nastepuje wyjscie z funkcji
                return;
            SVGScript.tc.pageActive = false;
            
            for(var i=0; i<this.posAr.length; i++) {//dodanie animacji do kazdej pozycji menu
                
                var obj = this.posAr[i].layerRef, posMenu = this.posAr[i];
                //Resetowanie pozycji x i przezroczystosci elementow menu
                anim_class.translate(obj, -posMenu.posX, -600);
                obj.setAttribute("opacity", 1);
            
                this.addAnim(anim_class.start(anim_class.add({
                    obj          : obj,
                    transformName: "translate",
                    animMode     : "<><",
                    values       : [0, 600],
                    totalTime    : SVGScript.tc.animMenuTime + Math.random() * 1000,
                    Fn: function() {
                        
                        }
                    })));                    
                };
                
            SVGScript.showHideTxtBackground(0);//ukrycie warstwy z zawartoscia tekstowa
                
            this.addNoActiveFnCallback(function() {//funkcja uruchamiana gdy wszystkie zarejestroane animacje menu zostaly zakonczone
               
                });
                
            },
        hide : function(pageID) {//Ukrycie menu
            
            for(var i=0; i<this.posAr.length; i++) {
                
                var obj = this.posAr[i].layerRef,
                    direction = (Math.random() > 0.5)? 1 : -1,
                    tx = 900, animTime = SVGScript.tc.animMenuTime + Math.random() * 1000;
                    
                this.posAr[i].posX = tx * direction;

                this.addAnim(anim_class.start(anim_class.add({
                    obj          : obj,
                    attrName     : "opacity",
                    values       : [1, 0.5],
                    precision    : 1,
                    totalTime    : animTime
                    })));
                this.addAnim(anim_class.start(anim_class.add({
                    obj          : obj,
                    transformName: "rotate",
                    animMode     : "=",
                    values       : [720 * direction],
                    totalTime    : animTime
                    })));            
                this.addAnim(anim_class.start(anim_class.add({
                    obj          : obj,
                    transformName: "translate",
                    animMode     : "backIn",
                    precision    : -1,
                    values       : [tx * direction],
                    totalTime    : animTime
                    })));
                };
                this.addNoActiveFnCallback(function() {
                    SVGScript.showHideTxtBackground(1, pageID)
                    });
                
            }
        },
    animSecondaryMenu: (function() {                           
        var animTime  = 400,
            activePos = null,
            ty = 50;
        return {
            show: function(i) {
                
                if(activePos != null)
                    this.hide();
                activePos = i;
                
                var obj1 = SVGScript.tc.SVGsecondaryMenuPos[i],
                    obj2 = SVGScript.tc.SVGsecondaryMenuPpp[i];
                
                var Fn = function() {
                anim_class.start(anim_class.add({
                    obj: obj2,
                    animMode: "<><",
                    totalTime: animTime * 2,
                    values: [0, ty],
                    Fn: function() {}
                    }));                  
                    };
                anim_class.start(anim_class.add({
                    obj: obj1,
                    animMode: "backIn",
                    totalTime: animTime,
                    values: [0, ty],
                    Fn: Fn
                    }));
                },
            hide: function() {
                
                var obj2 = SVGScript.tc.SVGsecondaryMenuPos[activePos],
                    obj1 = SVGScript.tc.SVGsecondaryMenuPpp[activePos];
                
                var Fn = function() {
                anim_class.start(anim_class.add({
                    obj: obj2,
                    animMode: "<><",
                    totalTime: animTime * 2,
                    values: [0, -ty]
                    }));                  
                    };
                anim_class.start(anim_class.add({
                    obj: obj1,
                    animMode: "backIn",
                    totalTime: animTime,
                    values: [0, -ty],
                    Fn: Fn
                    }));                
                },
            reset: function() {
                /* Code */
                }
        }})(),
    animFootMenu: (function() {//Animacje dolnego menu (na stopce)
        
        var startWidth = null, Fn1 = Fn2 = Fn3 = function() {}, animTime = 200;
        
        return function(obj) {
        var rect = this.tc.SVGfootMenuUnderRect,
            bbRect = rect.getBBox(),
            bbPosMenu = obj.getBBox();            
        if(!startWidth) {
            startWidth = bbRect.width;
            };    
        var FnCallback = function() {};
        if(bbRect.x <= bbPosMenu.x) {
            Fn1 = function() {anim_class.animAttr(rect, "width", startWidth, bbPosMenu.x + bbPosMenu.width/2 - bbRect.x + startWidth/2, animTime, function() {Fn2(); Fn3()})};
            Fn2 = function() {anim_class.animAttr(rect, "width", rect.getBBox().width, startWidth, animTime)};
            Fn3 = function() {anim_class.animAttr(rect, "x", rect.getBBox().x, rect.getBBox().x + (rect.getBBox().width - startWidth), animTime)};
            Fn1();
            }
        else{
            Fn1 = function() {anim_class.animAttr(rect, "width", startWidth, startWidth/2 + (bbRect.x + startWidth/2 - (bbPosMenu.x + bbPosMenu.width/2)), animTime, function() {Fn3()})};
            Fn2 = function() {anim_class.animAttr(rect, "x", bbRect.x, (bbPosMenu.x + bbPosMenu.width/2) - startWidth/2, animTime)};
            Fn3 = function() {anim_class.animAttr(rect, "width", rect.getBBox().width, startWidth, animTime)};
            Fn1();
            Fn2();
            };
        }})(),
    toolTip: (function() {
        var active = false,
            showTime = 1500,
            animTime = 300,
            lastPositionX = null,
            XQueue = null,
            FnCallback = function() {},
            animHide = function(obj) {
                anim_class.start(anim_class.add({
                    obj: obj,
                    totalTime: animTime,
                    attrName: "opacity",
                    attrType: "style",
                    precision: 1,
                    values: [1, 0],
                    Fn : function() {
                        active = false;
                        lastPositionX = null;
                        if(XQueue != null) {
                            trans(obj, XQueue[0], XQueue[1]);
                            XQueue = null;
                            animShow(obj);
                            };
                        }
                    }));                  
                },
            animShow = function(obj) {
                active = true;
                anim_class.start(anim_class.add({
                    obj: obj,
                    totalTime: animTime,
                    attrType: "style",
                    attrName: "opacity",
                    values: [0, 1],
                    precision: 1,
                    Fn: function() {setTimeout(function() {animHide(obj)}, showTime)}
                    }));                
                },                
            trans = function(obj, finalObjPosX, difX) {
                anim_class.translate(obj, difX, 0);
                lastPositionX = finalObjPosX;
                };
        return {
            show: function(finalObj, textValue) {              
                
                var obj = SVGScript.tc.SVGtooltip;     
                var finalObjPosX = (finalObj.getCTM().e + finalObj.getBBox().x);  
                var objPosX      = (obj.getCTM().e + obj.getBBox().x);
                var difX = finalObjPosX - objPosX;
                if(finalObjPosX === lastPositionX)
                    return;
                
                if(active)
                    XQueue = [finalObjPosX, difX];
                else{
                    trans(obj, finalObjPosX, difX);
                    animShow(obj);
                    };
                }
        }})(),
    showHideTxtBackground: function(mode, pageID) {

        if(mode) {
            anim_class.start(anim_class.add({
                obj: SVGScript.tc.SVGtxtBackgroundRef,
                attrName: "opacity",
                attrType: "style",
                values: [0, 1],
                precision: 1,
                totalTime: SVGScript.tc.animPageTime,
                Fn: function() {
                    SVGScript.tc.pageActive = true;
                    SVGScript.animSecondaryMenu.show(pageID);
                    }
                }));
            window.parent.siteScript.showText(pageID);
            }       
        else{
            anim_class.start(anim_class.add({
                obj: SVGScript.tc.SVGtxtBackgroundRef,
                attrName: "opacity",
                attrType: "style",
                precision: 1,
                values: [1, 0],
                totalTime: SVGScript.tc.animPageTime
                }));
            window.parent.siteScript.hideText(); 
            };
        },
    slider: (function() {//Tworzenie suwaka. Suwak i jego tlo powinno byc bez transformacji (szczegolnie bez skalowania)
        
        var scaleFactor = 1,
            animTime = 150,
            active = false,
            animTerminate = false,
            obj1,
            obj1bb,
            obj2,
            yMin,
            yMax,
            elPosStart = mousePosStart = {},
            startWidth,
            y,
            tc,
            _this_,
            //Funkcja nie dziala prawidlowo w IE, oraz FF
            //getScaleFactor = function(obj) {//Pobranie wspolczynnika skali obiektu
            //    var svg = document.documentElement,
            //        pt  = svg.createSVGPoint(), m;
            //    pt.x = 1; pt.y = 1;
            //    m = obj.getTransformToElement(svg).inverse();
            //    m.e = m.f = 0;
            //    pt = pt.matrixTransform(m);
            //    return {x: pt.x, y: pt.y};
            //    },
            getScaleFactor = function(obj) {//Pobranie wspolczynnika skali obiektu wzgledem elementu glownego
                var cntW = window.parent.siteScript.config.svgContainerRef.clientWidth;
                var cntH = window.parent.siteScript.config.svgContainerRef.clientHeight;
                var ratio = (cntW/cntH)/(960/720);
                var scale = {};
                if(ratio > 1) {
                    scale.x = cntH/720;
                    scale.y = scale.x;
                    }
                else{
                    scale.x = cntW/960;
                    scale.y = scale.x;
                    };
                return scale;
                },                 
            //getDocFactor = function() {//Pobranie wspolczynnika skali dokumentu
            //    var cnt = SVGScript.tc.svgContainerRef,
            //        bb  = document.documentElement.getBBox();
            //    return {
            //        x: cnt.clientWidth/bb.width,
            //        y: cnt.clientHeight/bb.height
            //        };
            //    },
            refreshFactor = function() {
                var newFactor = getScaleFactor(obj1).y;
                if(newFactor != scaleFactor) {
                    scaleFactor = newFactor;
                    window.parent.siteScript.txtContainerInit();
                    };
                setTimeout(refreshFactor, 100);
                };

        return {
            init: function() {
                _this_ = this;
                tc     = SVGScript.tc;
                obj1   = tc.SVGsliderRef[0];
                obj1bb = obj1.getBBox();
                yMin   = obj1bb.y;
                obj2   = tc.SVGsliderRef[1];
                obj2bb = obj2.getBBox();
                yMax   = obj2bb.height + obj2bb.y - obj1bb.height; 
                startWidth = obj1bb.width;
                
                obj1.style.cursor = "default";
                refreshFactor();
                this.addEvents();
                },
            addEvents: function() {
                obj1.onmouseover = function() {
                    if(active)
                        return;
                    _this_.anim(1);
                    };
                obj1.onmouseout = function() {
                    if(active)
                        return;                    
                    _this_.anim(0);
                    };
                obj1.onmousedown = function(evt) {
                    elPosStart = {x: parseInt(obj1.getAttribute("x")), y: parseInt(obj1.getAttribute("y"))};
                    mousePosStart = {x: evt.clientX, y: evt.clientY};
                    active = true;                    
                    };
                obj1.addEventListener("mouseup", function(evt) {
                    active = false;
                    evt.stopPropagation();
                    }, false);
                document.addEventListener("mouseup", function() {
                    if(active)
                        _this_.anim(0);
                    active = false;
                    }, false);
                document.onmousemove = function(evt) {
                    if(!active || SVGScript.blockEvents)
                        return;
                    
                    y = elPosStart.y + (evt.clientY - mousePosStart.y) / scaleFactor;
                    if(y > yMax) y = yMax;
                    if(y < yMin) y = yMin;
                    obj1.setAttribute("y", y);
                    tc.sliderCallbackFn((y - yMin)/(yMax - yMin));
                    };
                },
            reset: function() {
                if(tc.textContainerDiv.clientHeight >= tc.textValueDiv.clientHeight)
                    this.hide();
                else
                    this.show();
                obj1.setAttribute("y", yMin);
                },
            show: function() {
                obj1.style.display = "block";
                },
            hide: function() {
                obj1.style.display = "none";
                },
            anim: function(mode) {
                if(mode) {
                    anim_class.animAttr(obj1, "width", obj1bb.width, obj1bb.width + 10, animTime);
                    anim_class.animAttr(obj1, "x", obj1bb.x, obj1bb.x - 5, animTime, function() {
                        if(animTerminate)
                            _this_.anim(0);
                        });
                    }
                else{
                    animTerminate = true;
                    anim_class.animAttr(obj1, "width", obj1bb.width + 10, obj1bb.width, animTime);
                    anim_class.animAttr(obj1, "x", obj1bb.x - 5, obj1bb.x, animTime, function() {
                        animTerminate = false;
                        });    
                    }
                }        
        }})()
    };

    
    
    
      




















