def is_prime(n, k=128):
    """ Sprawdza, czy liczba jest pierwsza 
        Argumenty:
            n -- int -- liczba do sprawdzenia
            k -- int -- liczba testów do przeprowadzenia
        Funkcja zwraca True, jeżeli liczba jest pierwsza
    """
    # Sprawdzenie, czy n nie jest parzyste
    # Należy pamiętać, że 2 jest liczbą pierwszą!
    if n == 2 or n == 3:
        return True
    if n <= 1 or n % 2 == 0:
        return False
    # Znajdź r i s
    s = 0
    r = n - 1
    while r & 1 == 0:
        s += 1
        r //= 2
    # Wykonuję k testów
    for _ in range(k):
        a = randrange(2, n - 1)
        x = pow(a, r, n)
        if x != 1 and x != n - 1:
            j = 1
            while j < s and x != n - 1:
                x = pow(x, 2, n)
                if x == 1:
                    return False
                j += 1
            if x != n - 1:
                return False
    return True
