key = 'abcdefghijklmnopqrstuvwxyz'
def enc_substitution(n, plaintext):
    result = ''
    for l in plaintext.lower():
        try:
            i = (key.index(l) + n) % 26
            result += key[i]
        except ValueError:
            result += l
    return result.lower()

def dec_substitution(n, ciphertext):
    result = ''
    for l in ciphertext:
        try:
            i = (key.index(l) - n) % 26
            result += key[i]
        except ValueError:
            result += l
    return result

origtext = 'Uwazamy nastepujace prawa za oczywiste: wszyscy ludzie stworzeni sa rownymi'
ciphertext = enc_substitution(13, origtext)
plaintext = dec_substitution(13, ciphertext)
print(origtext)
print(ciphertext)
print(plaintext)
