"""
Rozdział 5. Implementacja szyfru strumieniowego ARC4
"""
def arc4crypt(data, key):
    x = 0
    box = range(256)
    for i in range(256):
        x = (x + box[i] + ord(key[i % len(key)])) % 256
        # Wymiana wartości w obiekcie zakresu
        box = list(box)
        box[i], box[x] = box[x], box[i]
    x = 0
    y = 0
    out = []
    for char in data:
        x = (x + 1) % 256
        y = (y + box[x]) % 256
        box[x], box[y] = box[y], box[x]
        out.append(chr(ord(char) ^ box[(box[x] + box[y]) % 256]))
    
    return ''.join(out)

key = 'SuperTajnyKlucz!!'
origtext = 'Nurkuj! Nurkuj! Nurkuj!'
ciphertext = arc4crypt(origtext, key)
plaintext = arc4crypt(ciphertext, key)
print('Oryginalny tekst: {}'.format(origtext))
print()
print('Szyfrogram: ', repr(ciphertext))
print()
print('Odszyfrowany tekst: {}'.format(plaintext))
print()