def egcd(a, b):
    if a == 0:
        return (b, 0, 1)
    else:
        g, y, x = egcd(b % a, a)
    return (g, x - (b // a) * y, y)

def modinv(a, m):
    g, x, y = egcd(a, m)
    if g != 1:
        raise Exception('Odwrotność modulo nie istnieje')
    else:
        return x % m

a = 102721840089015263978980446
p = 6768924473842051155435121

print(modinv(a, p))
#4751454584755824717584097
