#!/usr/bin/env python
import numpy as np
import matplotlib.mlab as mlab
import matplotlib.pyplot as plt
from scipy.stats import norm
mu, sigma = 100, 15
x = mu + sigma*np.random.randn(10000)
# Histogram
n, bins, patches = plt.hist(x, 50, density=True, facecolor='green', alpha=0.75)
# Dodanie do wykresu krzywej otrzymanej metodą najlepszego dopasowania
y = norm.pdf(bins, mu, sigma)
l = plt.plot(bins, y, 'r--', linewidth=1)
plt.xlabel('IQ')
plt.ylabel('Prawdopodobieństwo')
plt.title(r'$\mathrm{Histogram\ IQ:}\ \mu=100,\ \sigma=15$')
plt.axis([40, 160, 0, 0.03])
plt.grid(True)
plt.show()
