"""init

Revision ID: b947f1f6b692
Revises: 
Create Date: 2025-11-30 12:15:54.021563

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = 'b947f1f6b692'
down_revision: Union[str, Sequence[str], None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('users',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('wk_ident', sa.String(length=20), nullable=True),
    sa.Column('name', sa.String(length=100), nullable=True),
    sa.Column('nip', sa.String(length=20), nullable=True),
    sa.Column('email', sa.String(length=100), nullable=False),
    sa.Column('phone', sa.String(length=20), nullable=True),
    sa.Column('hashed_password', sa.String(), nullable=True),
    sa.Column('balance', sa.Float(), nullable=True),
    sa.Column('otp_secret', sa.String(), nullable=True),
    sa.Column('is_active', sa.Boolean(), nullable=True),
    sa.Column('creation_date', sa.DateTime(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_users_email'), 'users', ['email'], unique=True)
    op.create_index(op.f('ix_users_id'), 'users', ['id'], unique=False)
    op.create_index(op.f('ix_users_nip'), 'users', ['nip'], unique=False)
    op.create_index(op.f('ix_users_wk_ident'), 'users', ['wk_ident'], unique=False)
    op.create_table('wk',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('relay_state', sa.String(), nullable=True),
    sa.Column('authn_request_id', sa.String(), nullable=True),
    sa.Column('generated_at', sa.DateTime(), nullable=True),
    sa.Column('token', sa.String(), nullable=True),
    sa.Column('name_id', sa.String(), nullable=True),
    sa.Column('session_index', sa.String(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_wk_id'), 'wk', ['id'], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_wk_id'), table_name='wk')
    op.drop_table('wk')
    op.drop_index(op.f('ix_users_wk_ident'), table_name='users')
    op.drop_index(op.f('ix_users_nip'), table_name='users')
    op.drop_index(op.f('ix_users_id'), table_name='users')
    op.drop_index(op.f('ix_users_email'), table_name='users')
    op.drop_table('users')
    # ### end Alembic commands ###
