# generated by datamodel-codegen:
#   filename:  se.json
#   timestamp: 2025-09-19T19:15:45+00:00
# Poprawka BaseModel -> RootModel, gdy występuje root (__root__ -> root)

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import List, Optional

from pydantic import BaseModel, RootModel, Field, constr


class OfficialId(BaseModel):
    id: str = Field(..., description='Id')
    referenceRegistry: str = Field(
        ...,
        description='Rejestr referencyjny',
        example='pesel, PESEL, regon, REGON, krs, KRS, nip, NIP, ue, UE',
    )


class ReferenceRegistryEnum(Enum):
    pesel = 'pesel'
    regon = 'regon'
    krs = 'krs'
    nip = 'nip'
    ue = 'ue'


class AddressType(Enum):
    correspondence = 'correspondence'
    headquarters = 'headquarters'


class Country(Enum):
    A1 = 'A1'
    AD = 'AD'
    AE = 'AE'
    AF = 'AF'
    AG = 'AG'
    AI = 'AI'
    AL = 'AL'
    AM = 'AM'
    AN = 'AN'
    AO = 'AO'
    AQ = 'AQ'
    AR = 'AR'
    AS = 'AS'
    AT = 'AT'
    AU = 'AU'
    AW = 'AW'
    AZ = 'AZ'
    BA = 'BA'
    BB = 'BB'
    BD = 'BD'
    BE = 'BE'
    BF = 'BF'
    BG = 'BG'
    BH = 'BH'
    BI = 'BI'
    BJ = 'BJ'
    BM = 'BM'
    BN = 'BN'
    BO = 'BO'
    BR = 'BR'
    BS = 'BS'
    BT = 'BT'
    BV = 'BV'
    BW = 'BW'
    BY = 'BY'
    BZ = 'BZ'
    CA = 'CA'
    CC = 'CC'
    CD = 'CD'
    CF = 'CF'
    CG = 'CG'
    CH = 'CH'
    CI = 'CI'
    CK = 'CK'
    CL = 'CL'
    CM = 'CM'
    CN = 'CN'
    CO = 'CO'
    CR = 'CR'
    CU = 'CU'
    CV = 'CV'
    CX = 'CX'
    CY = 'CY'
    CZ = 'CZ'
    DE = 'DE'
    DJ = 'DJ'
    DK = 'DK'
    DM = 'DM'
    DO = 'DO'
    DZ = 'DZ'
    EC = 'EC'
    EE = 'EE'
    EG = 'EG'
    ER = 'ER'
    ES = 'ES'
    ET = 'ET'
    FI = 'FI'
    FJ = 'FJ'
    FK = 'FK'
    FM = 'FM'
    FR = 'FR'
    GA = 'GA'
    GB = 'GB'
    GD = 'GD'
    GE = 'GE'
    GG = 'GG'
    GH = 'GH'
    GI = 'GI'
    GM = 'GM'
    GN = 'GN'
    GQ = 'GQ'
    GR = 'GR'
    GS = 'GS'
    GT = 'GT'
    GU = 'GU'
    GW = 'GW'
    GY = 'GY'
    HK = 'HK'
    HM = 'HM'
    HN = 'HN'
    HR = 'HR'
    HT = 'HT'
    HU = 'HU'
    ID = 'ID'
    IE = 'IE'
    IL = 'IL'
    IM = 'IM'
    IN = 'IN'
    IO = 'IO'
    IQ = 'IQ'
    IR = 'IR'
    IS = 'IS'
    IT = 'IT'
    JE = 'JE'
    JM = 'JM'
    JO = 'JO'
    JP = 'JP'
    KE = 'KE'
    KG = 'KG'
    KH = 'KH'
    KI = 'KI'
    KM = 'KM'
    KN = 'KN'
    KP = 'KP'
    KR = 'KR'
    KW = 'KW'
    KY = 'KY'
    KZ = 'KZ'
    LA = 'LA'
    LB = 'LB'
    LC = 'LC'
    LI = 'LI'
    LK = 'LK'
    LR = 'LR'
    LS = 'LS'
    LT = 'LT'
    LU = 'LU'
    LV = 'LV'
    LY = 'LY'
    MA = 'MA'
    MD = 'MD'
    MG = 'MG'
    MH = 'MH'
    MK = 'MK'
    ML = 'ML'
    MM = 'MM'
    MN = 'MN'
    MO = 'MO'
    MP = 'MP'
    MR = 'MR'
    MS = 'MS'
    MT = 'MT'
    MU = 'MU'
    MV = 'MV'
    MW = 'MW'
    MX = 'MX'
    MY = 'MY'
    MZ = 'MZ'
    NA = 'NA'
    NC = 'NC'
    NE = 'NE'
    NF = 'NF'
    NG = 'NG'
    NI = 'NI'
    NL = 'NL'
    NO = 'NO'
    NP = 'NP'
    NR = 'NR'
    NU = 'NU'
    NZ = 'NZ'
    OM = 'OM'
    PA = 'PA'
    PE = 'PE'
    PF = 'PF'
    PG = 'PG'
    PH = 'PH'
    PK = 'PK'
    PL = 'PL'
    PN = 'PN'
    PS = 'PS'
    PT = 'PT'
    PW = 'PW'
    PY = 'PY'
    QA = 'QA'
    RO = 'RO'
    RU = 'RU'
    RW = 'RW'
    SA = 'SA'
    SB = 'SB'
    SC = 'SC'
    SD = 'SD'
    SE = 'SE'
    SG = 'SG'
    SH = 'SH'
    SI = 'SI'
    SK = 'SK'
    SL = 'SL'
    SM = 'SM'
    SN = 'SN'
    SO = 'SO'
    SR = 'SR'
    ST = 'ST'
    SV = 'SV'
    SY = 'SY'
    SZ = 'SZ'
    TC = 'TC'
    TD = 'TD'
    TF = 'TF'
    TG = 'TG'
    TH = 'TH'
    TJ = 'TJ'
    TK = 'TK'
    TM = 'TM'
    TN = 'TN'
    TO = 'TO'
    TR = 'TR'
    TT = 'TT'
    TV = 'TV'
    TW = 'TW'
    TZ = 'TZ'
    UA = 'UA'
    UG = 'UG'
    UM = 'UM'
    US = 'US'
    UY = 'UY'
    UZ = 'UZ'
    VA = 'VA'
    VC = 'VC'
    VE = 'VE'
    VG = 'VG'
    VI = 'VI'
    VN = 'VN'
    VU = 'VU'
    W1 = 'W1'
    WF = 'WF'
    WS = 'WS'
    YE = 'YE'
    YU = 'YU'
    ZA = 'ZA'
    ZM = 'ZM'
    ZR = 'ZR'
    ZW = 'ZW'


class TypeOfStreet(Enum):
    street = 'street'
    avenue = 'avenue'
    plaza = 'plaza'
    square = 'square'
    boulevard = 'boulevard'
    roundabout = 'roundabout'
    park = 'park'
    market = 'market'
    route = 'route'
    road = 'road'
    estate = 'estate'
    garden = 'garden'
    island = 'island'
    coast = 'coast'
    other = 'other'


class AddressData(BaseModel):
    addressType: AddressType = Field(..., description='typ adresu')
    country: Optional[Country] = Field(
        None,
        description='Organizacje międzynarodowe\nAndora\nZjednoczone Emiraty Arabskie\nAfganistan\nAntigua i Barbuda\nAnguilla\nAlbania\nArmenia\nAntyle Holenderskie\nAngola\nAntarktyka\nArgentyna\nSamoa Amerykańskie\nAustria\nAustralia\nAruba\nAzerbejdżan\nBośnia i Herzegowina\nBarbados\nBangladesz\nBelgia\nBurkina Faso\nBułgaria\nBahrajn\nBurundi\nBenin\nBermudy\nBrunei Darussalam\nBoliwia\nBrazylia\nBahamy\nBhutan\nBouveta, Wyspa\nBotswana\nBiałoruś\nBelize\nKanada\nKokosowe (Keelinga), Wyspy\nKongo, Republika Demokratyczna\nRepublika Środkowo-Afrykańska\nKongo\nSzwajcaria\nWybrzeże Kości Słoniowej\nCooka, Wyspy\nChile\nKamerun\nChiny\nKolumbia\nKostaryka\nKuba\nZielony Przylądek\nBożego Narodzenia, Wyspa\nCypr\nRepublika Czeska\nNiemcy\nDżibuti\nDania\nDominika\nRepublika Dominikany\nAlgieria\nEkwador\nEstonia\nEgipt\nErytrea\nHiszpania\nEtiopia\nFinlandia\nRepublika Fidżi\nFalklandy\nMikronezja, Federalne Stany\nFrancja\nGabon\nWielka Brytania\nGrenada\nGruzja\nGuernsey\nGhana\nGibraltar\nGambia\nGwinea\nGwinea Równikowa\nGrecja\nPołudniowa Georgia i Wyspy Południowe Sandwich\nGwatemala\nGuam\nGwinea Bissau\nGujana\nHong Kong\nHeart i McDonald, Wyspy\nHonduras\nChorwacja\nHaiti\nWęgry\nIndonezja\nIrlandia\nIzrael\nMan, Wyspa\nIndie\nBrytyjskie Terytorium Oceanu Indyjskiego\nIrak\nIran\nIslandia\nWłochy\nJersey\nJamajka\nJordania\nJaponia\nKenia\nKirgistan\nKambodża\nKiribati\nKomory\nSaint Kitts i Nevis\nKoreańska Republika Ludowo-Demokratyczna\nRepublika Korei\nKuwejt\nKajmany\nKazachstan\nLaos\nLiban\nSaint Lucia\nLichtenstein\nSri Lanka\nLiberia\nLesotho\nLitwa\nLuksemburg\nŁotwa\nLibia\nMaroko\nMołdowa\nMadagaskar\nMarshalla, Wyspy\nMacedonia\nMali\nMyanmar (Birma)\nMongolia\nMakao\nPółnocne Mariany\nMauretania\nMontserrat\nMalta\nMauritius\nMalediwy\nMalawi\nMeksyk\nMalezja\nMozambik\nNamibia\nNowa Kaledonia\nNiger\nNorfolk, Wyspa\nNigeria\nNikaragua\nNiderlandy\nNorwegia\nNepal\nNauru\nNiue\nNowa Zelandia\nOman\nPanama\nPeru\nPolinezja Francuska\nPapua - Nowa Gwinea\nFilipiny\nPakistan\nPolska\nPitcairn\nPalestyna, Obszar okupowany\nPortugalia\nPalau\nParagwaj\nKatar\nRumunia\nRosja\nRuanda\nArabia Saudyjska\nWyspy Salomona\nSeszele\nSudan\nSzwecja\nSingapur\nŚwięta Helena\nSłowenia\nSłowacja\nSierra Leone\nSan Marino\nSenegal\nSomalia\nSurinam\nWyspy Świętego Tomasza i Książęca\nSalwador\nSyria\nSuazi\nTurks i Caicos, Wyspy\nCzad\nFrancuskie Terytoria Południowe\nTogo\nTajlandia\nTadżykistan\nTokelau\nTurkmenistan\nTunezja\nTonga\nTurcja\nTrynidad i Tobago\nTuvalu\nTajwan\nTanzania\nUkraina\nUganda\nPowiernicze Wyspy Pacyfiku Stanów Zjednoczonych\nStany Zjednoczone\nUrugwaj\nUzbekistan\nWatykan\nSaint Vincent i Grenadyny\nWenezuela\nBrytyjskie Wyspy Dziewicze\nWyspy Dziewicze Stanów Zjednoczonych\nWietnam\nVanuatu\nGaza i Jerycho\nWallis i Futuna, Wyspy\nSamoa Zachodnie\nJemen\nJugosławia\nRepublika Południowej Afryki\nZambia\nZair\nZimbabwe\n',
    )
    street: Optional[constr(max_length=64)] = Field(None, description='Ulica')
    postalCode: Optional[str] = Field(None, description='Kod pocztowy')
    city: Optional[constr(max_length=64)] = Field(None, description='Miasto')
    buildingNumber: Optional[constr(max_length=16)] = Field(
        None, description='Numer bloku'
    )
    streetNumberOrDomesticPremises: Optional[constr(max_length=16)] = Field(
        None,
        description='Numer posesji lub ulicy, czyli to co jest na tabliczce z adresem na budynku',
    )
    flatNumber: Optional[constr(max_length=16)] = Field(
        None, description='Numer mieszkania w budynkach wielorodzinnych'
    )
    typeOfStreet: Optional[TypeOfStreet] = Field(
        None,
        description='ulica\naleja\nplac\nskwer\nbulwar\nrondo\npark\nrynek\nszosa\ndroga\nosiedle\nogród\nwyspa\nwybrzeże\ninne\n',
    )
    postalOffice: Optional[constr(max_length=64)] = Field(None, description='Poczta')
    postOfficeBox: Optional[constr(max_length=64)] = Field(
        None, description='Numer skrytki pocztowej'
    )
    voivodeship: Optional[constr(max_length=64)] = Field(
        None, description='Województwo'
    )
    district: Optional[constr(max_length=64)] = Field(None, description='Powiat')
    community: Optional[constr(max_length=64)] = Field(None, description='Gmina')


class Status400(BaseModel):
    errorCode: Optional[str] = Field(None, description='Kod błędu', example='EDOR-VE')
    errorId: Optional[str] = Field(
        None, description='Id błędu.', example='7770c1c4-e07b-479d-a496-a69eb9488366'
    )
    errorDescription: Optional[str] = Field(
        None, description='Opis błędu', example='Nie znaleziono aktywnego ADE nadawcy.'
    )


class EDeliveryAddressData(BaseModel):
    ade: Optional[str] = Field(None, description='Electronic delivery address')
    validFrom: Optional[datetime] = None
    isMainAddress: Optional[bool] = None


class EdaOwner(BaseModel):
    organizationName: Optional[str] = Field(
        None,
        description='Pełna nazwa podmiotu, zgodnie z\xa0wpisem w odpowiednim rejestrze, ewidencji, statucie lub innym dokumencie tego typu odpowiednim dla rodzaju podmiotu.',
        example='Poczta Polska Spółka Akcyjna',
    )
    organizationIdentifier: Optional[str] = Field(
        None,
        description='Jeden z identyfikatorów podmiotu, np. NIP, KRS, REGON organizacji.',
        example='VATPL-5250007313 lub NTRPL-0000334972',
    )
    countryName: Optional[str] = Field(
        None, description='Międzynarodowy skrót nazwy kraju.', example='PL'
    )
    stateOrProvinceName: Optional[str] = Field(
        None,
        description='Nazwa województwa, w którym subskrybent ma swoją siedzibę.',
        example='mazowieckie',
    )
    localityName: Optional[str] = Field(
        None,
        description='Nazwa miejscowości, w której subskrybent ma swoją siedzibę.',
        example='Warszawa',
    )
    postalCode: Optional[str] = Field(
        None, description='Kod pocztowy.', example='00-940'
    )
    streetAddress: Optional[str] = Field(
        None,
        description='Nazwa ulicy, na której subskrybent ma swoją siedzibę.',
        example='Rodziny Hiszpańskich',
    )
    houseIdentifier: Optional[str] = Field(
        None,
        description='Numer identyfikujący budynek, w\xa0którym subskrybent ma swoją siedzibę.',
        example=8,
    )


class ClientCertSubject(RootModel):
    root: str = Field(
        ...,
        description='DN certyfikatu użytkownika.',
        example='C=PL,O=MSWIA,OU=SRP,CN=Jan Kowalski,SN=73081886298',
    )


class BaeSearch(BaseModel):
    entityName: Optional[constr(max_length=128)] = Field(
        None, description='Nazwa podmiotu publicznego lub prywatnego'
    )
    name: Optional[constr(max_length=64)] = Field(None, description='Imię')
    surname: Optional[constr(max_length=64)] = Field(None, description='Nazwisko')
    professionalTitle: Optional[constr(max_length=256)] = Field(
        None, description='Tytuł zawodowy dla zawodów zaufania lub komornika'
    )
    recipientEdas: Optional[List[str]] = Field(
        None, description='Lista adresów do doręczeń elektronicznych odbiorcy'
    )
    senderEda: Optional[str] = Field(
        None, description='Adres do doręczeń elektronicznych nadawcy'
    )
    officialIds: Optional[List[OfficialId]] = Field(
        None, description='Lista identyfikatorów - PESEL,REGON, ...'
    )
    correspondenceAddress: Optional[AddressData] = None
    headquartersAddress: Optional[AddressData] = None


class BaeSearchData(BaseModel):
    name: Optional[constr(max_length=64)] = Field(None, description='Imię')
    surname: Optional[constr(max_length=64)] = Field(None, description='Nazwisko')
    professionalTitle: Optional[constr(max_length=256)] = Field(
        None, description='Tytuł zawodowy dla zawodów zaufania lub komornika'
    )
    legalForm: Optional[str] = Field(None, description='Oznaczenie formy prawnej')
    designatedOperator: Optional[bool] = Field(
        None, description='Wskazuje czy operator jest wyznaczony'
    )
    address: Optional[EDeliveryAddressData] = None
    entityName: Optional[constr(max_length=128)] = Field(
        None, description='Nazwa podmiotu publicznego lub prywatnego'
    )
    officialIds: Optional[List[OfficialId]] = Field(
        None, description='Lista identyfikatorów - PESEL,REGON, ...'
    )
    headquartersAddress: Optional[AddressData] = None
    correspondenceAddress: Optional[AddressData] = None
    nipStatus: Optional[constr(max_length=64)] = None


class BaeSearchResponse(BaseModel):
    baeSearchData: Optional[List[BaeSearchData]] = None
    comment: Optional[constr(max_length=256)] = Field(None, description='Komentarz')
