/*
 * Decompiled with CFR 0.152.
 */
package rene.util.xml;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import rene.util.SimpleByteBuffer;
import rene.util.SimpleStringBuffer;
import rene.util.list.ListElement;
import rene.util.xml.XmlReaderException;
import rene.util.xml.XmlTag;
import rene.util.xml.XmlTagPI;
import rene.util.xml.XmlTagRoot;
import rene.util.xml.XmlTagText;
import rene.util.xml.XmlTranslator;
import rene.util.xml.XmlTree;

public class XmlReader {
    BufferedReader In;
    SimpleStringBuffer buf;
    String Line;
    int LinePos;

    public XmlReader() {
        this.buf = new SimpleStringBuffer(10000);
        this.Line = null;
        this.In = null;
    }

    public XmlReader(BufferedReader in) {
        this.buf = new SimpleStringBuffer(10000);
        this.Line = null;
        this.In = in;
    }

    public XmlReader(InputStream in) throws XmlReaderException {
        block15: {
            this.buf = new SimpleStringBuffer(10000);
            this.Line = null;
            try {
                int c2;
                int k;
                BufferedInputStream rin = new BufferedInputStream(in);
                SimpleByteBuffer bb = new SimpleByteBuffer(10000);
                while ((k = rin.read()) >= 0) {
                    bb.append((byte)k);
                }
                rin.close();
                byte[] b2 = bb.getByteArray();
                ByteArrayInputStream bin = new ByteArrayInputStream(b2);
                XmlReader R = null;
                try {
                    R = new XmlReader(new BufferedReader(new InputStreamReader((InputStream)bin, "ASCII")));
                }
                catch (UnsupportedEncodingException ex) {
                    R = new XmlReader(new BufferedReader(new InputStreamReader(bin)));
                }
                String Encoding = null;
                do {
                    if ((c2 = R.read()) != -1) continue;
                    throw new Exception("<?xml> tag not found");
                } while (c2 != 60 || !R.found("?xml"));
                String s = R.scanFor("?>");
                if (s == null) {
                    throw new Exception("<?xml> tag error");
                }
                int n = s.indexOf("encoding=\"");
                if (n >= 0) {
                    int m = (s = s.substring(n += "encoding=\"".length())).indexOf(34);
                    if (m < 0) {
                        throw new Exception("Closing bracket missing");
                    }
                    Encoding = s.substring(0, m).toUpperCase();
                    if (Encoding.equals("UTF-8")) {
                        Encoding = "UTF8";
                    }
                }
                bin = new ByteArrayInputStream(b2);
                if (Encoding == null) {
                    this.In = new BufferedReader(new InputStreamReader(bin));
                    break block15;
                }
                try {
                    this.In = new BufferedReader(new InputStreamReader((InputStream)bin, Encoding));
                }
                catch (UnsupportedEncodingException e2) {
                    try {
                        this.In = new BufferedReader(new InputStreamReader((InputStream)bin, "ASCII"));
                    }
                    catch (UnsupportedEncodingException ex) {
                        this.In = new BufferedReader(new InputStreamReader(bin));
                    }
                }
            }
            catch (Exception e3) {
                throw new XmlReaderException(e3.toString());
            }
        }
    }

    public void init(InputStream in) throws XmlReaderException {
        block15: {
            try {
                int c2;
                int k;
                BufferedInputStream rin = new BufferedInputStream(in);
                SimpleByteBuffer bb = new SimpleByteBuffer(10000);
                while ((k = rin.read()) >= 0) {
                    bb.append((byte)k);
                }
                rin.close();
                byte[] b2 = bb.getByteArray();
                ByteArrayInputStream bin = new ByteArrayInputStream(b2);
                XmlReader R = null;
                try {
                    R = new XmlReader(new BufferedReader(new InputStreamReader((InputStream)bin, "ASCII")));
                }
                catch (UnsupportedEncodingException ex) {
                    R = new XmlReader(new BufferedReader(new InputStreamReader(bin)));
                }
                String Encoding = null;
                do {
                    if ((c2 = R.read()) != -1) continue;
                    throw new Exception("<?xml> tag not found");
                } while (c2 != 60 || !R.found("?xml"));
                String s = R.scanFor("?>");
                if (s == null) {
                    throw new Exception("<?xml> tag error");
                }
                int n = s.indexOf("encoding=\"");
                if (n >= 0) {
                    int m = (s = s.substring(n += "encoding=\"".length())).indexOf(34);
                    if (m < 0) {
                        throw new Exception("Closing bracket missing");
                    }
                    Encoding = s.substring(0, m).toUpperCase();
                    if (Encoding.equals("UTF-8")) {
                        Encoding = "UTF8";
                    }
                }
                bin = new ByteArrayInputStream(b2);
                if (Encoding == null) {
                    this.In = new BufferedReader(new InputStreamReader(bin));
                    break block15;
                }
                try {
                    this.In = new BufferedReader(new InputStreamReader((InputStream)bin, Encoding));
                }
                catch (UnsupportedEncodingException e2) {
                    try {
                        this.In = new BufferedReader(new InputStreamReader((InputStream)bin, "ASCII"));
                    }
                    catch (UnsupportedEncodingException ex) {
                        this.In = new BufferedReader(new InputStreamReader(bin));
                    }
                }
            }
            catch (Exception e3) {
                throw new XmlReaderException(e3.toString());
            }
        }
    }

    public XmlTree scan() throws XmlReaderException {
        int c2;
        do {
            if ((c2 = this.read()) != -1) continue;
            return null;
        } while (c2 != 60 || !this.found("?xml"));
        String s = this.scanFor("?>");
        if (s == null) {
            return null;
        }
        XmlTree t = new XmlTree(new XmlTagRoot());
        t.addchild(new XmlTree(new XmlTagPI(s)));
        this.scanContent(t);
        return t;
    }

    public void scanContent(XmlTree t) throws XmlReaderException {
        while (true) {
            String s;
            if ((s = this.scanFor('<')) == null) {
                if (t.getTag() instanceof XmlTagRoot) {
                    return;
                }
                this.exception("File ended surprisingly");
            }
            if (!this.empty(s)) {
                t.addchild(new XmlTree(new XmlTagText(XmlTranslator.toText(s))));
            }
            if (this.found("!--")) {
                s = this.scanFor("-->");
                continue;
            }
            if (this.found("!")) {
                s = this.scanTagFor('>');
                continue;
            }
            if (this.found("?")) {
                s = this.scanTagFor("?>");
                t.addchild(new XmlTree(new XmlTagPI(s)));
                continue;
            }
            s = this.scanTagFor('>');
            if (s == null) {
                this.exception("> missing");
            }
            if (s.startsWith("/")) {
                if (s.substring(1).equals(t.getTag().name())) {
                    return;
                }
                this.exception("End tag without start tag");
            }
            if (s.endsWith("/")) {
                t.addchild(new XmlTree(new XmlTag(s.substring(0, s.length() - 1))));
                continue;
            }
            XmlTree t0 = new XmlTree(new XmlTag(s));
            this.scanContent(t0);
            t.addchild(t0);
        }
    }

    public boolean empty(String s) {
        int n = s.length();
        int i = 0;
        while (i < n) {
            char c2 = s.charAt(i);
            if (c2 != ' ' && c2 != '\n' && c2 != '\t') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int skipBlanks() throws XmlReaderException {
        int c2;
        while ((c2 = this.read()) == 32 || c2 == 9 || c2 == 10) {
        }
        return c2;
    }

    public String scanFor(char end) throws XmlReaderException {
        this.buf.clear();
        int c2 = this.read();
        while (c2 != end) {
            this.buf.append((char)c2);
            c2 = this.read();
            if (c2 >= 0) continue;
            return null;
        }
        return this.buf.toString();
    }

    public String scanFor(String s) throws XmlReaderException {
        this.buf.clear();
        while (!this.found(s)) {
            int c2 = this.read();
            if (c2 < 0) {
                return null;
            }
            this.buf.append((char)c2);
        }
        int i = 0;
        while (i < s.length()) {
            this.read();
            ++i;
        }
        return this.buf.toString();
    }

    public String scanTagFor(char end) throws XmlReaderException {
        this.buf.clear();
        int c2 = this.read();
        while (c2 != end) {
            if (c2 == 34) {
                this.buf.append((char)c2);
                while (true) {
                    if ((c2 = this.read()) < 0) {
                        return null;
                    }
                    if (c2 == 34) break;
                    this.buf.append((char)c2);
                }
                this.buf.append((char)c2);
            } else if (c2 == 39) {
                this.buf.append((char)c2);
                while (true) {
                    if ((c2 = this.read()) < 0) {
                        return null;
                    }
                    if (c2 == 39) break;
                    this.buf.append((char)c2);
                }
                this.buf.append((char)c2);
            } else {
                this.buf.append((char)c2);
            }
            c2 = this.read();
            if (c2 >= 0) continue;
            return null;
        }
        return this.buf.toString();
    }

    public String scanTagFor(String s) throws XmlReaderException {
        this.buf.clear();
        while (!this.found(s)) {
            int c2 = this.read();
            if (c2 < 0) {
                return null;
            }
            if (c2 == 34) {
                this.buf.append((char)c2);
                while (true) {
                    if ((c2 = this.read()) < 0) {
                        return null;
                    }
                    if (c2 == 34) break;
                    this.buf.append((char)c2);
                }
                this.buf.append((char)c2);
                continue;
            }
            if (c2 == 39) {
                this.buf.append((char)c2);
                while (true) {
                    if ((c2 = this.read()) < 0) {
                        return null;
                    }
                    if (c2 == 39) break;
                    this.buf.append((char)c2);
                }
                this.buf.append((char)c2);
                continue;
            }
            this.buf.append((char)c2);
        }
        int i = 0;
        while (i < s.length()) {
            this.read();
            ++i;
        }
        return this.buf.toString();
    }

    public int read() throws XmlReaderException {
        block6: {
            block5: {
                try {
                    if (this.Line == null) {
                        this.Line = this.In.readLine();
                        this.LinePos = 0;
                    }
                    if (this.Line != null) break block5;
                    return -1;
                }
                catch (Exception e2) {
                    return -1;
                }
            }
            if (this.LinePos < this.Line.length()) break block6;
            this.Line = null;
            return 10;
        }
        return this.Line.charAt(this.LinePos++);
    }

    public boolean found(String s) {
        int n = s.length();
        if (this.LinePos + n > this.Line.length()) {
            return false;
        }
        int i = 0;
        while (i < n) {
            if (s.charAt(i) != this.Line.charAt(this.LinePos + i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void exception(String s) throws XmlReaderException {
        throw new XmlReaderException(s, this.Line, this.LinePos);
    }

    public static void main(String[] args) {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("rene\\util\\xml\\test.xml"), "UTF8"));
            XmlReader reader = new XmlReader(in);
            XmlTree tree = reader.scan();
            in.close();
            XmlReader.print(tree);
        }
        catch (XmlReaderException e2) {
            System.out.println(String.valueOf(e2.toString()) + "\n" + e2.getLine() + "\n" + "Position : " + e2.getPos());
        }
        catch (IOException e3) {
            System.out.println(e3);
        }
    }

    public static void print(XmlTree t) {
        XmlTag tag = t.getTag();
        System.out.print("<" + tag.name());
        int i = 0;
        while (i < tag.countParams()) {
            System.out.print(" " + tag.getParam(i) + "=\"" + tag.getValue(i) + "\"");
            ++i;
        }
        System.out.println(">");
        ListElement el = t.children().first();
        while (el != null) {
            XmlReader.print((XmlTree)el.content());
            el = el.next();
        }
        System.out.println("</" + tag.name() + ">");
    }

    public static boolean testXml(String s) {
        int i = 0;
        while (i < s.length()) {
            char c2 = s.charAt(i);
            if (c2 == '<') break;
            ++i;
        }
        if (i >= s.length()) {
            return false;
        }
        return s.substring(i).startsWith("<?xml");
    }
}

