/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.dialogs;

import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextField;
import rene.gui.ButtonAction;
import rene.gui.CheckboxAction;
import rene.gui.DoActionListener;
import rene.gui.Global;
import rene.gui.IconBar;
import rene.gui.MyChoice;
import rene.gui.MyLabel;
import rene.gui.MyPanel;
import rene.gui.Panel3D;
import rene.gui.TextFieldAction;
import rene.util.FileName;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelFrame;
import rene.zirkel.construction.Construction;
import rene.zirkel.dialogs.HelpCloseDialog;

public class ExportTemplateDialog
extends HelpCloseDialog {
    ZirkelFrame ZF;
    Construction C;
    TextField PageTitle;
    TextField CFile;
    TextField Codebase;
    Checkbox Job;
    Checkbox CopyJar;
    Panel CP;
    Choice Style;
    boolean OK = false;
    IconBar IBa;
    IconBar IBb;
    boolean SaveDimensions = true;
    boolean Restrict;
    static String[] ISb = new String[]{"back", "delete", "undo", "showcolor", "showname", "showvalue", "color", "colors", "hidden", "macro0", "replay", "arrow", "obtuse", "solid", "grid", "thickness0", "type0", "partial", "plines", "smallicons", "twolines", "macrobar", "qintersection", "qpointon", "qchoice", "indicate", "draw", "rename", "ticks", "function"};
    static String[] ISb0 = new String[]{"back", "delete", "undo", "showcolor", "showname", "showvalue", "color", "colors", "hidden", "macro", "replay", "arrow", "obtuse", "solid", "grid", "thickness", "type", "partial", "plines", "smallicons", "twolines", "macrobar", "qintersection", "qpointon", "qchoice", "indicate", "draw", "rename", "ticks", "function"};
    static String[] ST = new String[]{"plain", "3D", "icons", "full", "nonvisual", "breaks"};

    public ExportTemplateDialog(ZirkelFrame zf, Construction c2, boolean restrict) {
        super(zf, Zirkel.name("export.title"), true);
        this.ZF = zf;
        this.C = c2;
        this.Restrict = restrict;
        this.setLayout(new BorderLayout());
        MyPanel p = new MyPanel();
        p.setLayout(new GridLayout(0, 2));
        p.add(new MyLabel(Zirkel.name("export.pagetitle")));
        this.PageTitle = new TextFieldAction((DoActionListener)this, "export.pagetitle", 32);
        p.add(this.PageTitle);
        this.PageTitle.setText(FileName.purefilename(zf.Filename));
        p.add(new MyLabel(Zirkel.name("export.codebase")));
        this.Codebase = new TextFieldAction((DoActionListener)this, "export.codebase", 32);
        p.add(this.Codebase);
        this.Codebase.setText(Global.getParameter("export.codebase", "."));
        p.add(new MyLabel(""));
        this.CopyJar = new CheckboxAction(this, Zirkel.name("export.copyjar"));
        p.add(this.CopyJar);
        this.CopyJar.setState(false);
        p.add(new MyLabel(Zirkel.name("export.file")));
        this.CFile = new TextFieldAction((DoActionListener)this, "export.file", 32);
        p.add(this.CFile);
        this.CFile.setText(String.valueOf(Global.getParameter("export.path", "")) + FileName.filename(zf.Filename));
        if (zf.ZC.isJob()) {
            p.add(new MyLabel(""));
            this.Job = new CheckboxAction(this, Zirkel.name("export.job"));
            p.add(this.Job);
            this.Job.setState(true);
        }
        this.Style = new MyChoice();
        int i = 0;
        while (i < ST.length) {
            this.Style.add(Global.name("export." + ST[i]));
            ++i;
        }
        int style = Global.getParameter("export.style", 0);
        if (style <= 1 && this.ZF.ZC.isJob()) {
            style = 3;
        }
        this.Style.select(style);
        p.add(new MyLabel(Zirkel.name("export.style")));
        p.add(this.Style);
        this.add("North", new Panel3D(p));
        MyPanel icons = new MyPanel();
        icons.setLayout(new GridLayout(0, 1));
        this.IBa = new IconBar(this.ZF);
        String ica = restrict ? Global.getParameter("restrictedicons", "point line segment ray circle circle3 fixedcircle fixedangle intersection") : Global.getParameter("export.icons", "point line segment ray circle circle3 fixedcircle fixedangle intersection");
        int i2 = 0;
        while (i2 < 26) {
            String s = ZirkelFrame.ObjectStrings[i2];
            this.IBa.addToggleLeft(s);
            if (ica.equals("full") || ica.indexOf(s) >= 0) {
                this.IBa.setState(s, true);
            }
            ++i2;
        }
        icons.add(new Panel3D(this.IBa));
        this.IBb = new IconBar(this.ZF);
        String icb = restrict ? Global.getParameter("restrictedicons", "back hidden color twolines ") : Global.getParameter("export.tools", "back hidden color twolines ");
        int i3 = 0;
        while (i3 < ISb.length) {
            String s = ISb[i3];
            if (s.equals("qintersection")) {
                this.IBb.addSeparatorLeft();
            }
            if (s.equals("twolines")) {
                this.IBb.addSeparatorLeft();
            }
            if (s.equals("draw")) {
                this.IBb.addSeparatorLeft();
            }
            this.IBb.addToggleLeft(s);
            if (icb.equals("full") || icb.indexOf(ISb[i3]) >= 0) {
                this.IBb.setState(s, true);
            }
            ++i3;
        }
        icons.add(new Panel3D(this.IBb));
        this.IBb.setState("qchoice", Global.getParameter("options.choice", false));
        this.IBb.setState("qintersection", Global.getParameter("options.intersection", false));
        this.IBb.setState("qpointon", Global.getParameter("options.pointon", false));
        this.IBb.setState("indicate", !Global.getParameter("options.indicate.simple", false));
        this.add("Center", icons);
        MyPanel buttons = new MyPanel();
        buttons.add(new ButtonAction(this, Zirkel.name("ok"), "OK"));
        buttons.add(new ButtonAction(this, Zirkel.name("abort"), "Close"));
        this.addHelp(buttons, "htmlexporttemplate");
        this.add("South", buttons);
        this.pack();
        if (this.getSize().width > 750) {
            this.setSize(750, this.getSize().height);
        }
    }

    public void doAction(String o) {
        this.OK = false;
        if (o.equals("OK")) {
            this.OK = true;
            int i = this.Style.getSelectedIndex();
            if (i >= 0) {
                Global.setParameter("export.style", i);
            }
            this.getIcons();
            this.getTools();
            this.doclose();
        } else {
            super.doAction(o);
        }
    }

    public boolean isAborted() {
        return !this.OK;
    }

    public String getPageTitle() {
        return this.PageTitle.getText();
    }

    public String getIcons() {
        StringBuffer b2 = new StringBuffer();
        boolean first = true;
        int i = 0;
        while (i < 26) {
            String s = ZirkelFrame.ObjectStrings[i];
            if (this.IBa.getState(s)) {
                if (!first) {
                    b2.append(' ');
                }
                b2.append(s);
                first = false;
            }
            ++i;
        }
        if (!this.Restrict) {
            Global.setParameter("export.icons", b2.toString());
        }
        return b2.toString();
    }

    public String getTools() {
        StringBuffer b2 = new StringBuffer();
        StringBuffer b1 = new StringBuffer();
        b2.append(" ");
        b1.append(" ");
        int i = 0;
        while (i < ISb.length) {
            String s = ISb[i];
            if (this.IBb.getState(s)) {
                b1.append(s);
                b1.append(" ");
            }
            if (s.equals("indicate") && !this.IBb.getState(s)) {
                b2.append("noindicate ");
            } else if (this.IBb.getState(s)) {
                b2.append(ISb0[i]);
                b2.append(" ");
            }
            ++i;
        }
        if (!this.Restrict) {
            Global.setParameter("export.tools", b1.toString());
        }
        return b2.toString();
    }

    public String getStyle() {
        int n = this.Style.getSelectedIndex();
        if (n >= 0) {
            Global.setParameter("export.style", n);
        }
        if (n < 0) {
            return ST[0];
        }
        return ST[n];
    }

    public String getFile() {
        String path = FileName.pathAndSeparator(this.CFile.getText());
        Global.setParameter("export.path", path);
        return this.CFile.getText();
    }

    public String getCodebase() {
        Global.setParameter("export.codebase", this.Codebase.getText());
        return this.Codebase.getText();
    }

    public boolean isJob() {
        if (this.Job == null) {
            return false;
        }
        return this.Job.getState();
    }

    public boolean getCopyJar() {
        return this.CopyJar.getState();
    }
}

